#!/bin/bash

# Script minimal de preparation d'une machine de controle Ansible pour GCV6
set -euo pipefail

pushd ./files

manquants=0
for tarfile in \
    curl-7.76_centos6.v2.tar.bz2 \
    emc2-rpms.tar.xz \
    ncdu_tmux_jq.tar.bz2 \
    openssl-3.2.1_centos6.v2.tar.bz2 \
    python3.11.10-centos6-20250927.tar.xz \
    python3.11.10-centos6-ansible-20250927.tar.xz \
    python3.11.10-centos6-venv-20250927.tar.xz \
    sqlite3_centos6.v2.tar.bz2 \
    venv-python-centos6.tar.xz;
do
    if [ ! -f "$tarfile" ]; then
        echo "archive $tarfile manquante"
        ((manquants++))
    fi

done

if [ manquant -gt 0 ]; then
exit 1
fi
popd

ADMINISTRATOR_USER="administrator"
LOCAL_DIR="/home/local"

# Verification root
if [ "$EUID" -ne 0 ]; then
    echo "Ce script doit etre execute en tant que root"
    exit 1
fi

# Verification CentOS 6
if [ -f /etc/centos-release ]; then
    if ! grep -q "release 6" /etc/centos-release; then
        echo "Ce script necessite CentOS 6"
        exit 1
    fi
else
    echo "Fichier /etc/centos-release introuvable"
    exit 1
fi

echo "Creation du groupe gestcom..."
# Creation du groupe gestcom si n'existe pas
if ! getent group gestcom &>/dev/null; then
    groupadd gestcom
    echo "Groupe gestcom cree"
else
    echo "Groupe gestcom existe deja"
fi

echo "Creation de l'utilisateur $ADMINISTRATOR_USER..."

# Creation utilisateur si n'existe pas
if ! id "$ADMINISTRATOR_USER" &>/dev/null; then
    useradd -m -G wheel -s /bin/bash "$ADMINISTRATOR_USER"
    usermod -aG gestcom "$ADMINISTRATOR_USER"
    #echo "admin123!" | passwd --stdin "$ADMINISTRATOR_USER"
    chage -d 0 "$ADMINISTRATOR_USER"
    echo "Utilisateur $ADMINISTRATOR_USER cree"
else
    echo "Utilisateur $ADMINISTRATOR_USER existe deja"
fi

# Configuration dossier utilisateur
user_home="/home/$ADMINISTRATOR_USER"
chmod 700 "$user_home"
chown "$ADMINISTRATOR_USER:$ADMINISTRATOR_USER" "$user_home"

# Creation dossier .ssh
ssh_dir="$user_home/.ssh"
mkdir -p "$ssh_dir"
chmod 700 "$ssh_dir"
chown "$ADMINISTRATOR_USER:$ADMINISTRATOR_USER" "$ssh_dir"

# Creation dossier .scripts
scripts_dir="$user_home/.scripts"
mkdir -p "$scripts_dir"
chmod 755 "$scripts_dir"
chown "$ADMINISTRATOR_USER:$ADMINISTRATOR_USER" "$scripts_dir"

echo "Generation cle SSH..."

# Generation cle SSH
key_file="$ssh_dir/id_rsa"
su -c "ssh-keygen -t rsa -b 4096 -f $key_file -C $ADMINISTRATOR_USER@ansible-control" "$ADMINISTRATOR_USER"
su -c "cp $key_file.pub $ssh_dir/authorized_keys" "$ADMINISTRATOR_USER"
su -c "chmod 600 $ssh_dir/authorized_keys" "$ADMINISTRATOR_USER"

echo "Installation Python et Ansible..."

# Creation repertoire local
mkdir -p "$LOCAL_DIR"

# Decompression archives si elles existent
if [ -f ./files/python3.11.10-centos6-20250927.tar.xz ]; then
    tar xJf ./files/python3.11.10-centos6-20250927.tar.xz -C "$LOCAL_DIR"
fi

if [ -f ./files/python3.11.10-centos6-ansible-20250927.tar.xz ]; then
    tar xJf ./files/python3.11.10-centos6-ansible-20250927.tar.xz -C "$LOCAL_DIR"
    chown -R "$ADMINISTRATOR_USER:$ADMINISTRATOR_USER" "$LOCAL_DIR/venv.ansible"
fi

if [ -f ./files/curl-7.76_centos6.v2.tar.bz2  ]; then 
    tar xjf ./files/curl-7.76_centos6.v2.tar.bz2 -C "/opt"
fi
if [ -f ./files/openssl-3.2.1_centos6.v2.tar.bz2 ]; then 
    tar xjf ./files/openssl-3.2.1_centos6.v2.tar.bz2 -C "/opt"
fi
if [ -f ./files/sqlite3_centos6.v2.tar.bz2 ]; then 
    tar xjf ./files/sqlite3_centos6.v2.tar.bz2 -C "/opt"
fi
if [ -f ./files/python3.11.10-centos6-venv-20250927.tar.xz ]; then 
    tar xJf ./files/python3.11.10-centos6-venv-20250927.tar.xz -C "$LOCAL_DIR"
fi

chown -R "gestcom:gestcom" "$LOCAL_DIR"

# Script d'activation
cat > "$scripts_dir/activate-ansible.sh" << 'EOF'
#!/bin/bash
export PATH=/home/local/python-3.11.10/bin:$PATH
source /home/local/venv.ansible/bin/activate
echo "Environnement Ansible active"
EOF

chmod +x "$scripts_dir/activate-ansible.sh"
chown "$ADMINISTRATOR_USER:$ADMINISTRATOR_USER" "$scripts_dir/activate-ansible.sh"

# Configuration sudoers
cat > "/etc/sudoers.d/$ADMINISTRATOR_USER" << EOF
$ADMINISTRATOR_USER ALL=(ALL) NOPASSWD: /home/${ADMINISTRATOR_USER}/.venv/bin/ansible-playbook
$ADMINISTRATOR_USER ALL=(ALL) ALL
EOF

chmod 440 "/etc/sudoers.d/$ADMINISTRATOR_USER"

# Ajout alias dans bashrc
echo "#alias activate-ansible='source ~/.scripts/activate-ansible.sh'" >> "/home/${ADMINISTRATOR_USER}/.bashrc"
echo "source ~/.scripts/activate-ansible.sh" >> "/home/${ADMINISTRATOR_USER}/.bashrc"

chown "$ADMINISTRATOR_USER:$ADMINISTRATOR_USER" "/home/${ADMINISTRATOR_USER}/.bashrc"

echo "=== INSTALLATION TERMINEE ==="
echo "Utilisateur: $ADMINISTRATOR_USER"
echo "Mot de passe a configurer"
echo "Cle SSH: $key_file"
echo "Pour activer Ansible: source ~/.scripts/activate-ansible.sh"
