# Role system_maintenance

Ce rôle Ansible configure la maintenance automatique des systèmes CentOS 6 et CentOS 9 pour l'environnement GCV6 ERP.

## Fonctionnalités

### Maintenance générale (tous les systèmes)
- **Rotation des logs** : Configuration automatique avec logrotate
- **Monitoring d'espace disque** : Script avancé avec alertes Discord
- **Nettoyage des fichiers temporaires** : Suppression automatique des fichiers *.tmp

### Maintenance spécifique CentOS 6
- **Nettoyage dbus** : Script automatique pour éviter l'accumulation de processus
- **Nettoyage de fichiers** : Suppression des logs et fichiers temporaires anciens
- **Installation de paquets hors ligne** : Installation d'outils via archives RPM locales
- **Suppression de PulseAudio** : Prévention du remplissage disque

## Variables

### Variables de planification (cron)

| Variable | Valeur par défaut | Description |
|----------|-------------------|-------------|
| `maintenance_dbus_cleanup_minute` | `"0"` | Minute pour le nettoyage dbus (CentOS 6) |
| `maintenance_dbus_cleanup_hour` | `"3"` | Heure pour le nettoyage dbus (CentOS 6) |
| `maintenance_file_cleanup_minute` | `"30"` | Minute pour le nettoyage fichiers |
| `maintenance_file_cleanup_hour` | `"3"` | Heure pour le nettoyage fichiers |
| `maintenance_tmp_cleanup_minute` | `"15"` | Minute pour le nettoyage /tmp |
| `maintenance_tmp_cleanup_hour` | `"4"` | Heure pour le nettoyage /tmp |
| `maintenance_disk_monitor_minute` | `"0"` | Minute pour le monitoring disque |
| `maintenance_disk_monitor_hour` | `"*/6"` | Heure pour le monitoring disque (toutes les 6h) |

### Variables d'activation/désactivation

| Variable | Valeur par défaut | Description |
|----------|-------------------|-------------|
| `maintenance_enable_dbus_cleanup` | `true` | Active le nettoyage dbus (CentOS 6) |
| `maintenance_enable_file_cleanup` | `true` | Active le nettoyage de fichiers |
| `maintenance_enable_tmp_cleanup` | `true` | Active le nettoyage /tmp |
| `maintenance_enable_disk_monitor` | `true` | Active le monitoring d'espace disque |
| `maintenance_enable_logrotate` | `true` | Active la configuration logrotate |
| `maintenance_enable_offline_installer` | `false` | Active l'installateur hors ligne (CentOS 6) |
| `maintenance_enable_offline_packages` | `false` | Active l'installation de paquets hors ligne (CentOS 6) |
| `maintenance_remove_pulseaudio` | `true` | Supprime PulseAudio (CentOS 6) |

### Variables de seuils et chemins

| Variable | Valeur par défaut | Description |
|----------|-------------------|-------------|
| `maintenance_disk_threshold` | `85` | Seuil d'alerte disque en pourcentage |
| `maintenance_rpm_archive_path` | `"files/ncdu_tmux_jq.tar.bz2"` | Chemin vers l'archive RPM |
| `maintenance_log_retention_days` | `7` | Rétention des logs en jours |
| `maintenance_pdf_retention_days` | `7` | Rétention des fichiers PDF en jours |

### Variables de configuration avancée

| Variable | Valeur par défaut | Description |
|----------|-------------------|-------------|
| `maintenance_log_directories` | `["/home/*/logs", "/tmp"]` | Répertoires à nettoyer |
| `maintenance_temp_file_patterns` | `["*.log", "*.pdf", "*.slk", "*.tmp"]` | Motifs de fichiers à supprimer |
| `db_paths` | `[]` | Liste de chemins de bases de données à exclure du nettoyage PDF uniquement |

**Note sur `db_paths`** : Cette variable accepte une liste de chemins qui seront exclus du nettoyage automatique des fichiers **PDF uniquement**. Les fichiers SLK seront nettoyés dans tous les répertoires, y compris les db_paths. Elle est compatible avec l'ancienne variable `db_path` (chaîne unique) qui sera automatiquement convertie en liste. Voir [DB_PATHS_EXCLUSION.md](DB_PATHS_EXCLUSION.md) pour plus de détails.

### Variables requises (vault)

| Variable | Description |
|----------|-------------|
| `vault_discord_alert_webhook_url` | URL du webhook Discord pour les alertes disque |

## Scripts déployés

### Script de monitoring disque (`disk_monitor.sh`)
- **Emplacement** : `/home/local/bin/disk_monitor.sh`
- **Fonctionnalités** :
  - Surveillance de l'espace disque avec seuils configurables
  - Alertes Discord avec hostname et adresse IP
  - Logging local et syslog
  - Mode verbeux disponible
- **Usage** : `./disk_monitor.sh [seuil]`

### Scripts CentOS 6 (dans `/sos/`)
- `killall_dbus.sh` - Nettoyage des processus dbus
- `nettoyage_fichier.sh` - Nettoyage des fichiers temporaires

## Exemple d'utilisation

```yaml
- hosts: centos_servers
  roles:
    - role: system_maintenance
      vars:
        maintenance_disk_threshold: 90
        maintenance_disk_monitor_hour: "*/4"
        maintenance_enable_offline_packages: true
        vault_discord_alert_webhook_url: "https://discord.com/api/webhooks/..."
```

## Dépendances

### Paquets installés automatiquement
- **CentOS 6** : `ncdu`, `tmux`, `jq`, `moreutils`
- **CentOS 9** : `ncdu`, `tmux`, `jq`, `inotify-tools`, `moreutils`

### Prérequis
- `curl` (pour les alertes Discord)
- `logrotate` (pour la rotation des logs)
- Accès root sur les machines cibles

## Structure des répertoires créés

```
/home/local/
├── bin/
│   ├── disk_monitor.sh          # Script de monitoring
│   └── yum-installer-multi.sh   # Installateur hors ligne (CentOS 6)
└── conf/
    └── logrotate.d/
        └── gcv-maintenance      # Configuration logrotate

/home/log/
└── gcv-maintenance/             # Logs de maintenance
    ├── disk-monitor.log
    └── disk-alert.log

/sos/                           # Scripts CentOS 6
├── killall_dbus.sh
└── nettoyage_fichier.sh
```

## Planification par défaut

| Tâche | Fréquence | Horaire |
|-------|-----------|---------|
| Monitoring disque | Toutes les 6h | :00 |
| Nettoyage dbus (CentOS 6) | Quotidien | 03:00 |
| Nettoyage fichiers | Quotidien | 03:30 |
| Nettoyage /tmp | Quotidien | 04:15 |

