# R�le Ansible : logrotate_setup

Ce rôle configure `logrotate` pour une base de données identifiée via la variable `db_path`. Il crée les dossiers de logs structurés (`daily`, `weekly`, etc.), génère un fichier de configuration logrotate et ajoute une tâche cron.

Pour chaque base de données sur l'os, il faut créer un dossier de logs. Imaginons que la VM
contient les bases de données `mydb` et `otherdb`, alors il faut créer les dossiers `/home/log/mydb` et `/home/log/otherdb`
et l'arborescence suivante :

```
/home/log/
├── conf
│   └── logrotate.conf
├── mydb
│   ├── daily
│   ├── weekly
│   ├── monthly
│   └── yearly
├── otherdb
│   ├── daily
│   ├── weekly
│   ├── monthly
│   └── yearly
```

Tous fichiers de logs (`*.log`) placés dans un dossier `daily` seront archivés quotidiennement, ceux dans `weekly` seront archivés hebdomadairement, etc.
Veillez à placer les fichiers de logs dans les bons dossiers en fonction de la fréquence de rotation souhaitée.

# Rôle Ansible : logrotate_setup

Surchargez db_path dans group_vars ou dans l?inventaire selon le nom de votre base.

# Exemple d'utilisation

```yaml
- hosts: centos6
  become: true
  vars:
    db_path: /var/lib/mydb  # Chemin de la base de données
  roles:
    - logrotate_setup
```
