#!/usr/bin/env python3
import sqlite3
import typer

def add_version(
    db_path: str = typer.Argument(..., help="Chemin vers la base de données SQLite"),
    version: str = typer.Argument(..., help="Version à ajouter"),
    date_str: str = typer.Argument(..., help="Date de déploiement (format YYYYMMDD)"),
    time_str: str = typer.Argument(..., help="Heure de déploiement (format HHMMSS)")
):
    """Ajouter une version de déploiement dans la base SQLite"""
    try:
        conn = sqlite3.connect(db_path)
        cursor = conn.cursor()
        
        # Supprimer l'ancienne entrée de cette version si elle existe
        cursor.execute('DELETE FROM deployments WHERE version = ?', (version,))
        
        # Insérer la nouvelle version en premier (ordre par id décroissant)
        cursor.execute('INSERT INTO deployments (version, date, time) VALUES (?, ?, ?)',
                      (version, date_str, time_str))
        
        conn.commit()
        conn.close()
        typer.echo(f"Version {version} ajoutée avec succès dans {db_path}")
        
    except sqlite3.Error as e:
        typer.echo(f"Erreur SQLite: {e}", err=True)
        raise typer.Exit(1)
    except Exception as e:
        typer.echo(f"Erreur: {e}", err=True)
        raise typer.Exit(1)

if __name__ == '__main__':
    typer.run(add_version)
