#!/bin/bash

# Configuration
DBNAME="gc"
TABLE="gc_factrc"
INDEXNAME="ux_factrc01"
DBACCESS="/usr/informix/bin/dbaccess"
DBACCESS="isql"

SCRIPT_NAME=$(basename $0 .sh)
FORCE=1

# Fichiers temporaires
ERRORLOG=$(mktemp)
SQLFILE=$(mktemp)


# Generer le fichier SQL à executer
cat <<EOF > "$SQLFILE"
-- Supprimer l'index existant
DROP INDEX $INDEXNAME;

SELECT nofac FROM gc_factrc
GROUP BY nofac
HAVING count(*)>1
INTO temp tnofac;

SELECT max(rowid) as m, nofac FROM gc_factrc
WHERE nofac in (SELECT nofac FROM tnofac)
GROUP BY nofac
INTO temp maxrowid;


DELETE FROM gc_factrc
WHERE nofac in (SELECT nofac FROM maxrowid)
AND rowid not in (SELECT m FROM maxrowid);

CREATE UNIQUE INDEX $INDEXNAME ON $TABLE (nofac);

EOF

echo ">> Etape 3 : Suppression des doublons et recreation de l'index..."
$DBACCESS $DBNAME < "$SQLFILE"

# Nettoyage
echo $ERRORLOG $SQLFILE
cp "$ERRORLOG" ${SCRIPT_NAME}.log
cp "$SQLFILE" ${SCRIPT_NAME}.sql
echo "log: ${SCRIPT_NAME}.log"
echo "SQL: ${SCRIPT_NAME}.sql"
echo "Script termine."

