#!/bin/bash

# Script pour générer les métadonnées de version Ansible
# À exécuter dans Jenkins après la création de l'archive

set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
VERSION="${1:-${BUILD_NUMBER:-$(date +%Y%m%d%H%M%S)}}"
GIT_COMMIT="${2:-${GIT_COMMIT:-unknown}}"
BUILD_URL="${3:-${BUILD_URL:-unknown}}"

# Générer le fichier de version
cat > "${SCRIPT_DIR}/.ansible_version" << EOF
${VERSION}
EOF

# Générer le fichier de métadonnées complet
cat > "${SCRIPT_DIR}/.ansible_metadata" << EOF
{
  "version": "${VERSION}",
  "git_commit": "${GIT_COMMIT}",
  "build_date": "$(date -u +%Y-%m-%dT%H:%M:%SZ)",
  "build_url": "${BUILD_URL}",
  "jenkins_build": "${BUILD_NUMBER:-unknown}"
}
EOF

echo "Métadonnées générées:"
echo "Version: ${VERSION}"
echo "Commit: ${GIT_COMMIT}"
echo "Date: $(date -u +%Y-%m-%dT%H:%M:%SZ)"