#!/bin/bash
# Télécharge les fichiers pour CentOS 6

HOST="ftp.example.com"  # À configurer
USER="user"             # À configurer
PASS="pass"             # À configurer
DIR="files"

mkdir -p "$DIR"

FILES=(
    "ncdu_tmux_jq.tar.bz2"
    "curl-7.76_centos6.v2.tar.bz2"
    "openssl-3.2.1_centos6.v2.tar.bz2"
    "sqlite3_centos6.v2.tar.bz2"
    "python3.11.10-centos6-20250927.tar.xz"
    "venv-python-centos6.tar.xz"
    "python3.11.10-centos6-ansible-20250927.tar.xz"
    "emc2-rpms.tar.xz"
)

cd "$DIR"
for f in "${FILES[@]}"; do
    echo "Téléchargement de $f..."
    ftp -n "$HOST" <<EOF
user $USER $PASS
cd centos6
get $f
bye
EOF
done

# Télécharge la dernière archive Gestion
LATEST=$(ftp -n "$HOST" <<EOF | grep -oE 'Gestion-centos6-[0-9.]+[a-z]+.*\.tar\.(bz2|xz)' | sort -V | tail -1
user $USER $PASS
cd centos6
ls
bye
EOF
)
[ -n "$LATEST" ] && ftp -n "$HOST" <<EOF
user $USER $PASS
cd centos6
get $LATEST
bye
EOF
