# Download Files - télécharger et téléverser sur le SFTP de EMC2

**download_file** est un programme C utilisant libcurl. Elle offre une interface CLI qui
demande le mot de passe de manière sécurisée.

## Fonctionnalités

- Téléchargement/Téléversement de fichiers via SFTP avec libcurl
- Interface CLI avec saisie sécurisée de mot de passe (masqué à l'écran)
- **Vérification automatique d'intégrité MD5** après téléchargement
- Configuration via fichier INI (`./config.ini`)
- Trois commandes principales:
  - `download` - Télécharge les fichiers de dépendances (python, curl...)
  - `latest` - Télécharge la dernière version de la GCV6 disponible
  - `version` - Télécharge une version spécifique de GCV6
- Support de listing des fichiers distants
- Recherche automatique de la dernière version avec regex

## Prérequis

### Dépendances système

- gcc
- curl > 7.6
- openssl > 3.2
- SSH2

**CentOS 6:**

Les dépendances ont été compilées voir

- `/opt/curl-7.76.1/lib/libcurl.a`
- `/opt/libssh2-1.11/lib64/libssh2.a`
- `/opt/zlib-1.3.1/lib/libz.a`
- `/opt/openssl-3.2.1/lib64/libssl.a` et `libcrypto.a`

**CentOS 9 :**

```bash
dnf install gcc make libcurl-devel openssl-devel
```

### Bibliothèque libcurl

Le programme nécessite libcurl avec support SFTP (via libssh2). Pour vérifier:

```bash
curl-config --protocols | grep -i sftp
```

Si SFTP n'est pas disponible, vous devrez compiler libcurl avec libssh2:

```bash
# Vérifier que curl est compilé avec SFTP
curl -V | grep -i sftp
```

## Compilation

### CentOS 9 (ou systèmes récents)

Utilise les bibliothèques système via pkg-config :

```bash
make -f Makefile.centos9 clean
make -f Makefile.centos9
```

### CentOS 6

Utilise des bibliothèques statiques compilées spécialement pour être à jour

```bash
make -f Makefile.centos6 clean
make -f Makefile.centos6
```

## Configuration

Le programme utilise un fichier de configuration `config.ini`:

```ini
# Configuration Download Files
[sftp]
host = votre-serveur-sftp.com
user = votre_utilisateur
```

**Note de sécurité:** Si le fichier est absent, il est automatiquement créé avec les
permissions 600 (lecture/écriture pour le propriétaire uniquement). Il faudra le modifier
pour le configurer

## Vérification d'intégrité MD5

Le programme vérifie automatiquement l'intégrité de tous les fichiers téléchargés en utilisant des fichiers MD5.

### Fonctionnement

1. **Téléchargement du fichier principal** : Le fichier est téléchargé normalement
2. **Téléchargement du fichier MD5** : Le programme tente de télécharger `fichier.md5` associé
3. **Calcul du hash MD5 local** : Le hash MD5 du fichier téléchargé est calculé
4. **Comparaison** : Le hash calculé est comparé au hash attendu du fichier `.md5`
5. **Validation** :
   - Si les hash correspondent : le fichier est validé
   - Si les hash diffèrent : le fichier est supprimé et une erreur est affichée

## Utilisation

##### --help :

Utilise l'aide pour lister les commandes disponibles

```bash
download_files --help
```

##### Commande download :

Télécharge tous les fichiers de dépendances prédéfinis:

```bash
# Télécharge les dépendances pour le système courant (centos 6 ou centos 9)
./download_files download

# Télécharge pour CentOS 9
./download_files download --osname centos9

# Liste uniquement les fichiers disponibles sans télécharger
./download_files download --list
```

##### Commande latest :

Télécharge la dernière version de l'archive GCV disponible:

```bash
# Télécharge la dernière version
./download_files latest

# Affiche uniquement le numéro de version sans télécharger
./download_files latest --version-only

# Pour CentOS 9
./download_files latest --osname centos9
```

##### Commande: version

Télécharge une version spécifique:

```bash
# Télécharge la version 6.06.011ad
./download_files version 6.06.011ad

# Pour CentOS 9
./download_files version 6.06.011ad --osname centos9

# Dans un répertoire spécifique
./download_files version master --dir /tmp/downloads
```

### Options communes

| Option               | Description                         | Défaut    |
| -------------------- | ----------------------------------- | --------- |
| `-o, --osname OS`    | Système d'exploitation cible        | `centos6` |
| `-d, --dir DIR`      | Répertoire de destination           | `files`   |
| `-l, --list`         | Liste uniquement (download)         | -         |
| `-v, --version-only` | Affiche version uniquement (latest) | -         |
| `-h, --help`         | Affiche l'aide                      | -         |

## Exemples d'utilisation

### Vérification de version avant mise à jour

```bash
#!/bin/bash

CURRENT_VERSION="6.06.011ad"
LATEST=$(./download_files latest --version-only)

if [ "$LATEST" != "$CURRENT_VERSION" ]; then
    echo "Nouvelle version disponible: $LATEST (actuelle: $CURRENT_VERSION)"
    ./download_files latest
else
    echo "Version à jour: $CURRENT_VERSION"
fi
```

## Limitations

- Pas de support des clés SSH (seulement user/pass)
- Pas de reprise après interruption
- Configuration en clair (pas de chiffrement)

## TODO / Améliorations futures

- [ ] Support des clés SSH publiques/privées
- [x] Vérification d'intégrité (checksums MD5)
- [ ] Support SHA256 au lieu de MD5
- [ ] Support de multiples serveurs (failover)
- [ ] Téléchargements parallèles
- [ ] Le fichier de config devrait être spécifié avec un argument
- [ ] Spécifier un chemin de téléchargement

## Licence

Conforme à la licence du projet GCV.
