# Guide de migration vers le nouveau système de téléchargement

## Vue d'ensemble

Ce guide explique comment migrer depuis l'ancien système de téléchargement vers le nouveau système basé sur le rôle `download_file` avec support de la variable `gestion_download_mode`.

## Avant / Après

### Avant (ancien système)

```yaml
# Dans deploy_gestion_centos6.yml (ancien)
pre_tasks:
  - name: Lister les archives disponibles localement
    find:
      paths: "{{ playbook_dir }}/roles/install_gestion/files"
      patterns: "Gestion-centos6-*.tar.xz"
    register: local_archives
    delegate_to: localhost

  # Pas de téléchargement automatique
  # Il fallait télécharger manuellement avec download_files.py
```

### Après (nouveau système)

```yaml
# Dans deploy_gestion_centos6.yml (nouveau)
pre_tasks:
  # Le mode de téléchargement est contrôlé par gestion_download_mode
  - name: "[Mode TARGET] Déployer download_file sur les sites cibles"
    # Téléchargement automatique depuis les sites cibles

  - name: "[Mode CONTROLLER] Télécharger sur la machine Ansible"
    # Téléchargement automatique sur la machine Ansible
```

## Étapes de migration

### Étape 1: Compiler les binaires avec suffixe

Le nouveau système nécessite des binaires avec suffixe OS.

```bash
cd ansible/download_files_tui/C

# Compiler et créer les binaires
make

# Créer les binaires avec suffixe
cp download_files download_files-centos6
cp download_files download_files-centos9

# Vérifier
ls -lh download_files-*
```

**Documentation complète:** [roles/download_file/BUILD.md](../roles/download_file/BUILD.md)

### Étape 2: Configurer les credentials dans le vault

Si ce n'est pas déjà fait, configurez les credentials FTP.

```bash
# Éditer le vault
ansible-vault edit group_vars/all/vault.yml

# Ajouter ou vérifier:
vault_emc2_sftp_host: "ftp.cluster030.hosting.ovh.net"
vault_emc2_sftp_user: "emcinfi"
vault_emc2_sftp_password: "votre_mot_de_passe"
```

### Étape 3: Choisir votre mode de téléchargement

#### Option A: Mode TARGET (recommandé)

**Avantages:**
- Bande passante optimisée
- Autonomie des sites
- Métriques par site

**Configuration:**
```yaml
# group_vars/centos6.yml
gestion_download_mode: target
```

**Ou dans l'inventaire:**
```ini
[centos6:vars]
gestion_download_mode=target
```

#### Option B: Mode CONTROLLER

**Avantages:**
- Compatible avec sites sans accès FTP
- Contrôle centralisé

**Configuration:**
```yaml
# group_vars/centos6.yml
gestion_download_mode: controller
```

**Ou dans l'inventaire:**
```ini
[centos6:vars]
gestion_download_mode=controller
```

### Étape 4: Tester avec un site de développement

```bash
# Test en dry-run
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K --check --limit dev-site

# Test réel sur un site de dev
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K --limit dev-site
```

### Étape 5: Déployer en production

```bash
# Déploiement progressif
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K --limit prod-site1
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K --limit prod-site2

# Déploiement complet
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K
```

## Scénarios de migration

### Scénario 1: Migration simple (tous les sites avec accès FTP)

**Situation:** Tous vos sites ont accès au serveur FTP.

**Migration:**
1. Compiler les binaires avec suffixe (Étape 1)
2. Configurer le vault (Étape 2)
3. Utiliser le mode target par défaut
4. Déployer

```bash
# Aucune configuration supplémentaire nécessaire
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K
```

**Résultat:** Les sites téléchargent directement depuis FTP.

### Scénario 2: Migration pour sites sans accès FTP

**Situation:** Vos sites n'ont pas d'accès au serveur FTP (firewall, VPN, etc.).

**Migration:**
1. Compiler les binaires avec suffixe (Étape 1)
2. Configurer le vault (Étape 2)
3. Forcer le mode controller

```bash
# Dans l'inventaire
[centos6:vars]
gestion_download_mode=controller

# Ou en ligne de commande
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K -e gestion_download_mode=controller
```

**Résultat:** La machine Ansible télécharge depuis FTP, puis copie vers les sites.

### Scénario 3: Migration mixte

**Situation:** Certains sites ont accès FTP, d'autres non.

**Migration:**
```ini
# inventory.ini
[sites_avec_ftp]
prod-site1.example.com
prod-site2.example.com

[sites_sans_ftp]
internal-site1.example.com
internal-site2.example.com

[centos6:children]
sites_avec_ftp
sites_sans_ftp

[sites_avec_ftp:vars]
gestion_download_mode=target

[sites_sans_ftp:vars]
gestion_download_mode=controller
```

**Résultat:** Configuration automatique selon le groupe.

## Vérification post-migration

### Mode TARGET

```bash
# Vérifier que download_file est déployé
ansible -i inventory.ini centos6 -m shell -a "which download_files" -b

# Vérifier les métriques
ansible -i inventory.ini centos6 -m shell -a "download-file-metrics stats" -b

# Vérifier la configuration
ansible -i inventory.ini centos6 -m shell -a "cat /etc/download_file/config.ini" -b
```

### Mode CONTROLLER

```bash
# Vérifier les archives sur Ansible controller
ls -lh roles/install_gestion/files/Gestion-centos6-*.tar.xz

# Vérifier que les archives ont été copiées sur les sites
ansible -i inventory.ini centos6 -m shell -a "ls -lh /tmp/ansible-tmp-*/Gestion-centos6-*.tar.xz" -b
```

## Retour en arrière

Si vous rencontrez des problèmes avec le nouveau système, vous pouvez revenir temporairement à l'ancien système.

### Option 1: Forcer le mode controller

```bash
# Utiliser le mode controller qui fonctionne comme l'ancien système
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K -e gestion_download_mode=controller
```

### Option 2: Téléchargement manuel

```bash
# Télécharger manuellement les archives
cd ansible
python3 download_files.py latest --osname centos6 --local-dir roles/install_gestion/files

# Puis déployer avec mode controller
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K -e gestion_download_mode=controller
```

## Avantages du nouveau système

### Par rapport à l'ancien système

| Fonctionnalité | Ancien système | Nouveau système |
|----------------|----------------|-----------------|
| Téléchargement automatique | ❌ Manuel | ✅ Automatique |
| Modes de téléchargement | ❌ Aucun | ✅ 2 modes (target/controller) |
| Métriques | ❌ Aucune | ✅ Complètes |
| Connectivité vérifiée | ❌ Non | ✅ Oui |
| Binaires spécifiques OS | ❌ Non | ✅ Oui (centos6/centos9) |
| Configuration centralisée | ❌ Non | ✅ Oui (inventaire) |
| Logs structurés | ❌ Non | ✅ Oui |
| Scripts de monitoring | ❌ Non | ✅ Oui |

## Dépannage de la migration

### Erreur: "Le binaire n'existe pas"

```
❌ Le binaire .../download_files-centos6 n'existe pas !
```

**Solution:**
```bash
cd ansible/download_files_tui/C
make
cp download_files download_files-centos6
cp download_files download_files-centos9
```

### Erreur: "Connectivité FTP échouée"

```
❌ ÉCHEC: Impossible de contacter ftp.cluster030.hosting.ovh.net:22
```

**Solutions:**
1. Vérifier le firewall sur les sites cibles
2. Utiliser le mode controller: `-e gestion_download_mode=controller`
3. Vérifier les credentials dans le vault

### Erreur: "Aucune archive trouvée"

```
❌ Aucune archive Gestion-centos6-*.tar.xz trouvée après téléchargement
```

**Solutions:**
1. Vérifier les logs de téléchargement
2. Tester le téléchargement manuel:
   ```bash
   ssh site1
   cd /etc/download_file
   sudo -u gestcom download-files-wrapper download centos6
   ```

## Support et documentation

- [Documentation complète des modes](DOWNLOAD_MODES.md)
- [Rôle download_file](../roles/download_file/README.md)
- [Guide de compilation](../roles/download_file/BUILD.md)
- [Guide d'intégration](../roles/download_file/INTEGRATION.md)
- [Guide de démarrage rapide](../roles/download_file/QUICKSTART.md)

## Checklist de migration

- [ ] Binaires `download_files-centos6` et `download_files-centos9` compilés
- [ ] Credentials FTP configurés dans le vault
- [ ] Mode de téléchargement choisi (target ou controller)
- [ ] Configuration dans l'inventaire ou group_vars
- [ ] Test sur un site de développement
- [ ] Vérification post-déploiement
- [ ] Documentation de la configuration choisie
- [ ] Formation de l'équipe sur le nouveau système

## Questions fréquentes

### Q: Dois-je migrer tous les sites en même temps?

**R:** Non, vous pouvez migrer progressivement. Utilisez `--limit` pour cibler des sites spécifiques.

### Q: Puis-je avoir des sites en mode target et d'autres en mode controller?

**R:** Oui ! Définissez `gestion_download_mode` par groupe ou par hôte dans l'inventaire.

### Q: Le mode controller est-il plus lent?

**R:** Oui, légèrement, car il télécharge puis copie. Mais il est plus compatible.

### Q: Les métriques sont-elles conservées?

**R:** Oui, en mode target. Les métriques sont stockées sur chaque site dans `/var/log/gcv/download_file_metrics.log`.

### Q: Puis-je forcer un téléchargement même si les archives existent?

**R:** En mode target, oui, exécutez directement `download-files-wrapper` sur les sites. En mode controller, supprimez les archives locales avant le déploiement.

## Conclusion

Le nouveau système de téléchargement offre plus de flexibilité, de visibilité et d'automatisation. La migration est progressive et compatible avec l'ancien système en utilisant le mode controller.

Pour toute question, consultez la documentation complète ou contactez l'équipe de support.
