# Modes de téléchargement des archives de gestion

## Vue d'ensemble

Le playbook `deploy_gestion_centos6.yml` supporte deux modes de téléchargement des archives de gestion, contrôlés par la variable `gestion_download_mode`.

## Variable de contrôle

### `gestion_download_mode`

Définit comment les archives de gestion sont obtenues avant l'installation.

**Valeurs possibles:**
- `target` (défaut) - Télécharger depuis les sites cibles
- `controller` - Copier depuis la machine Ansible

**Emplacement de définition:**
- Inventaire (`inventory.ini`)
- Variables de groupe (`group_vars/`)
- Variables d'hôte (`host_vars/`)
- Ligne de commande (`-e gestion_download_mode=...`)

## Mode TARGET (par défaut)

### Description

Dans ce mode, le rôle `download_file` est déployé sur chaque site cible, et les archives sont téléchargées directement depuis le serveur FTP vers les sites.

### Avantages

- ✅ **Bande passante optimisée** - Les archives sont téléchargées directement sur les sites
- ✅ **Pas de stockage local nécessaire** - La machine Ansible n'a pas besoin d'espace disque pour les archives
- ✅ **Métriques par site** - Chaque site enregistre ses propres métriques de téléchargement
- ✅ **Autonomie des sites** - Chaque site peut télécharger les archives indépendamment

### Prérequis

- Binaires `download_files-centos6` et `download_files-centos9` compilés
- Connectivité FTP depuis les sites cibles vers le serveur FTP
- Credentials FTP configurés dans le vault

### Fonctionnement

1. Le rôle `download_file` est déployé sur chaque site cible
2. La configuration FTP est créée (`/etc/download_file/config.ini`)
3. Le binaire `download-files-wrapper` télécharge les archives
4. Les métriques sont enregistrées localement sur chaque site
5. L'installation de la gestion démarre avec les archives téléchargées

### Utilisation

**Par défaut (mode target):**
```bash
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K
```

**Forcer le mode target:**
```bash
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K -e gestion_download_mode=target
```

**Dans l'inventaire:**
```ini
[centos6]
site1.example.com gestion_download_mode=target
site2.example.com gestion_download_mode=target
```

**Dans group_vars/centos6.yml:**
```yaml
gestion_download_mode: target
```

## Mode CONTROLLER

### Description

Dans ce mode, les archives sont téléchargées sur la machine Ansible (controller), puis copiées vers les sites cibles via Ansible.

### Avantages

- ✅ **Une seule connexion FTP** - Uniquement depuis la machine Ansible
- ✅ **Contrôle centralisé** - Les archives sont gérées centralement
- ✅ **Compatible avec sites sans accès FTP** - Les sites cibles n'ont pas besoin d'accès au serveur FTP
- ✅ **Cache local** - Les archives sont conservées localement pour plusieurs déploiements

### Prérequis

- Script Python `download_files.py` disponible sur la machine Ansible
- Python 3 installé sur la machine Ansible
- Espace disque suffisant sur la machine Ansible pour stocker les archives
- Connectivité FTP depuis la machine Ansible vers le serveur FTP

### Fonctionnement

1. Les archives sont recherchées dans `roles/install_gestion/files/`
2. Si aucune archive n'est trouvée, `download_files.py` est exécuté sur la machine Ansible
3. Les archives téléchargées sont stockées dans `roles/install_gestion/files/`
4. Ansible copie les archives vers les sites cibles lors de l'installation
5. L'installation de la gestion démarre avec les archives copiées

### Utilisation

**Forcer le mode controller:**
```bash
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K -e gestion_download_mode=controller
```

**Dans l'inventaire:**
```ini
[centos6]
site1.example.com gestion_download_mode=controller
site2.example.com gestion_download_mode=controller
```

**Dans group_vars/centos6.yml:**
```yaml
gestion_download_mode: controller
```

## Comparaison des modes

| Critère | Mode TARGET | Mode CONTROLLER |
|---------|-------------|-----------------|
| **Connexion FTP** | Depuis chaque site cible | Depuis la machine Ansible uniquement |
| **Bande passante** | Optimale (direct) | Multiple (Ansible → FTP, puis Ansible → sites) |
| **Espace disque Ansible** | Minimal | Important (stockage archives) |
| **Prérequis sites** | Accès FTP requis | Aucun accès FTP requis |
| **Métriques** | Par site | Centralisée |
| **Téléchargement** | Parallèle (tous sites) | Séquentiel (1 téléchargement, n copies) |
| **Déploiement binaire** | Oui (download_file) | Non |
| **Cache local** | Non | Oui |
| **Autonomie sites** | Haute | Faible |

## Cas d'usage recommandés

### Utiliser le mode TARGET quand:

- ✅ Les sites cibles ont une bonne connectivité vers le serveur FTP
- ✅ Vous voulez optimiser la bande passante
- ✅ Vous déployez sur de nombreux sites simultanément
- ✅ Vous voulez que chaque site soit autonome pour les téléchargements
- ✅ Vous avez besoin de métriques par site

### Utiliser le mode CONTROLLER quand:

- ✅ Les sites cibles n'ont pas d'accès au serveur FTP (firewall, VPN, etc.)
- ✅ Vous voulez un contrôle centralisé des archives
- ✅ Vous voulez éviter de déployer `download_file` sur les sites
- ✅ Vous avez une connexion lente ou instable vers le serveur FTP
- ✅ Vous déployez la même version sur plusieurs sites successivement

## Configuration par groupe ou hôte

### Par groupe dans l'inventaire

```ini
[centos6]
prod-site1.example.com
prod-site2.example.com

[centos6:vars]
gestion_download_mode=target
```

### Par hôte dans l'inventaire

```ini
[centos6]
# Sites avec accès FTP direct
prod-site1.example.com gestion_download_mode=target
prod-site2.example.com gestion_download_mode=target

# Sites derrière firewall sans accès FTP
internal-site1.example.com gestion_download_mode=controller
internal-site2.example.com gestion_download_mode=controller
```

### Dans group_vars/centos6.yml

```yaml
---
# Mode de téléchargement par défaut pour tous les sites CentOS 6
gestion_download_mode: target

# Autres variables...
gestion_version: last
gestion_force_install: false
```

### Dans host_vars/internal-site1.yml

```yaml
---
# Forcer le mode controller pour ce site spécifique
gestion_download_mode: controller

# Autres variables spécifiques à l'hôte...
```

## Exemples d'utilisation

### Exemple 1: Déploiement en production (mode target)

```bash
# Déployer sur tous les sites avec téléchargement direct
ansible-playbook -i production.ini deploy_gestion_centos6.yml -K

# Vérifier les métriques sur un site
ansible -i production.ini prod-site1 -m shell -a "download-file-metrics stats" -b
```

### Exemple 2: Déploiement en développement (mode controller)

```bash
# Télécharger une fois, déployer sur plusieurs sites de dev
ansible-playbook -i dev.ini deploy_gestion_centos6.yml -K -e gestion_download_mode=controller

# Les archives sont dans roles/install_gestion/files/
ls -lh roles/install_gestion/files/Gestion-centos6-*.tar.xz
```

### Exemple 3: Déploiement mixte

```ini
# inventory.ini
[centos6:children]
sites_avec_ftp
sites_sans_ftp

[sites_avec_ftp]
prod-site1.example.com
prod-site2.example.com

[sites_sans_ftp]
internal-site1.example.com
internal-site2.example.com

[sites_avec_ftp:vars]
gestion_download_mode=target

[sites_sans_ftp:vars]
gestion_download_mode=controller
```

```bash
# Déployer avec configuration mixte
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K
```

## Dépannage

### Mode TARGET

**Problème: Le téléchargement échoue sur les sites**

```bash
# Vérifier la connectivité FTP depuis un site
ansible -i inventory.ini site1 -m shell -a "nc -zv ftp.cluster030.hosting.ovh.net 22" -b

# Vérifier les métriques
ansible -i inventory.ini site1 -m shell -a "download-file-metrics stats" -b

# Vérifier les logs
ansible -i inventory.ini site1 -m shell -a "tail -50 /var/log/gcv/download_file_metrics.log" -b
```

**Problème: Le binaire download_files n'existe pas**

```bash
# Vérifier que les binaires avec suffixe existent
ls -lh download_files_tui/C/download_files-*

# Compiler si nécessaire
cd download_files_tui/C
make
cp download_files download_files-centos6
```

### Mode CONTROLLER

**Problème: Les archives ne se téléchargent pas**

```bash
# Vérifier que download_files.py existe
ls -l download_files.py

# Tester le téléchargement manuel
python3 download_files.py latest --osname centos6 --local-dir /tmp/test
```

**Problème: Manque d'espace disque sur Ansible controller**

```bash
# Vérifier l'espace disque
df -h roles/install_gestion/files/

# Nettoyer les anciennes archives
rm roles/install_gestion/files/Gestion-centos6-old-version-*.tar.xz
```

## Logs et débogage

### Activer le mode verbose

```bash
# Voir tous les détails du téléchargement
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K -vvv
```

### Vérifier le mode utilisé

```bash
# Le playbook affiche le mode au début
TASK [Afficher le mode de téléchargement]
ok: [site1] => {
    "msg": "Mode de téléchargement: target\nLes archives seront téléchargées depuis les sites cibles via download_file\n"
}
```

### Logs de téléchargement

**Mode TARGET:**
```bash
# Logs sur chaque site
ansible -i inventory.ini centos6 -m shell -a "tail -f /var/log/gcv/download_file_metrics.log" -b
```

**Mode CONTROLLER:**
```bash
# Logs sur la machine Ansible (stdout du playbook)
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K 2>&1 | tee deployment.log
```

## Références

- [Rôle download_file](../roles/download_file/README.md)
- [Guide de compilation des binaires](../roles/download_file/BUILD.md)
- [Intégration dans les playbooks](../roles/download_file/INTEGRATION.md)
- [Script Python download_files.py](../download_files.py)
