# Résumé de la migration vers db_paths

## Vue d'ensemble

Toutes les tâches Ansible qui utilisaient `db_path` (chemin unique de base de données) supportent maintenant `db_paths` (liste de chemins), avec rétrocompatibilité complète.

## Fichiers modifiés

### Playbooks principaux

#### 1. `deploy_gestion_centos6.yml`
- ✅ Normalisation automatique de `db_path` → `db_paths`
- ✅ Vérification qu'au moins un chemin est défini
- ✅ Conservation de `db_path` (premier élément) pour compatibilité

#### 2. `prep_gestion_sans_installation_gestion.yml`
- ✅ Même logique de normalisation que deploy_gestion_centos6.yml

### Rôles Ansible

#### 3. `roles/install_gestion/tasks/main.yml`
- ✅ Normalisation locale en `_local_db_paths`
- ✅ Création de dossiers (logos, csv, mod, dyn) pour **chaque** base
- ✅ Utilisation de `product()` pour itérer sur bases × dossiers

#### 4. `roles/logrotate_setup/tasks/main.yml`
- ✅ Normalisation locale en `_logrotate_db_paths`
- ✅ Création de répertoires de logs pour **chaque** base
- ✅ Support de structures multi-bases

#### 5. `roles/logrotate_setup/tasks/checks.yml`
- ✅ Vérification de `db_path` **ou** `db_paths`

#### 6. `roles/logrotate_setup/defaults/main.yml`
- ✅ Ajout de `db_paths: []` par défaut
- ✅ Documentation des deux formats

#### 7. `roles/system_maintenance/templates/sos/nettoyage_fichier.sh.j2`
- ✅ Utilisation directe de `db_paths` (liste)
- ✅ Génération dynamique de commandes `-path ... -prune` pour chaque chemin

#### 8. `roles/system_maintenance/defaults/main.yml`
- ✅ Ajout de `db_paths: []` par défaut
- ✅ Documentation avec exemples

#### 9. `roles/system_maintenance/README.md`
- ✅ Documentation de la variable `db_paths`
- ✅ Référence au guide détaillé

### Documentation

#### 10. `docs/DB_PATHS_USAGE.md` (nouveau)
- ✅ Guide complet d'utilisation
- ✅ Exemples de configuration
- ✅ Cas d'usage variés
- ✅ Guide de migration

#### 11. `roles/system_maintenance/DB_PATHS_EXCLUSION.md` (en attente)
- Documentation spécifique pour l'exclusion dans le nettoyage

## Logique de normalisation

Tous les playbooks et rôles appliquent cette logique :

```yaml
# Normalisation de db_path (string) vers db_paths (list)
db_paths: "{{ [db_path] if db_path is defined and db_path is string else (db_paths if db_paths is defined else []) }}"

# Pour compatibilité : db_path = premier élément de db_paths
db_path: "{{ db_paths[0] }}"
```

### Résultat

| Configuration d'entrée | Valeur de db_paths | Valeur de db_path |
|------------------------|-------------------|-------------------|
| `db_path: "/home/dbs"` | `["/home/dbs"]` | `"/home/dbs"` |
| `db_paths: ["/home/dbs"]` | `["/home/dbs"]` | `"/home/dbs"` |
| `db_paths: ["/a", "/b"]` | `["/a", "/b"]` | `"/a"` |
| Aucune | **Erreur** | **Erreur** |

## Compatibilité

### ✅ Configurations existantes (100% compatibles)

Toutes ces configurations continuent de fonctionner sans modification :

```yaml
# Inventaire
db_path="/home/gestcom/dbs"

# host_vars/server.yml
db_path: "/home/gestcom/dbs"

# group_vars/production.yml
db_path: "/home/gestcom/dbs"
```

### ✅ Nouvelles configurations (multi-bases)

```yaml
# host_vars/server.yml
db_paths:
  - "/home/gestcom/dbs"
  - "/home/bases/prod"
  - "/home/bases/test"
```

## Fonctionnalités multi-bases

### 1. Création de dossiers annexes

**Avant (une base) :**
```
/home/gestcom/dbs/logos
/home/gestcom/dbs/csv
/home/gestcom/dbs/mod
/home/gestcom/dbs/dyn
```

**Après (trois bases) :**
```
/home/gestcom/dbs/logos
/home/gestcom/dbs/csv
/home/gestcom/dbs/mod
/home/gestcom/dbs/dyn

/home/bases/prod/logos
/home/bases/prod/csv
/home/bases/prod/mod
/home/bases/prod/dyn

/home/bases/test/logos
/home/bases/test/csv
/home/bases/test/mod
/home/bases/test/dyn
```

### 2. Répertoires de logs

**Structure générée :**
```
/home/log/dbs/hourly/
/home/log/dbs/daily/
/home/log/dbs/weekly/
/home/log/dbs/monthly/
/home/log/dbs/yearly/

/home/log/prod/hourly/
/home/log/prod/daily/
...
```

### 3. Exclusion du nettoyage automatique

**Script généré (une base) :**
```bash
find /home -path /home/gestcom/dbs -prune -o -type f \( -name "*.pdf" -o -name "*.slk" \) -mtime +7 -exec rm -f {} \;
```

**Script généré (trois bases) :**
```bash
find /home \
  -path /home/gestcom/dbs -prune -o \
  -path /home/bases/prod -prune -o \
  -path /home/bases/test -prune -o \
  -type f \( -name "*.pdf" -o -name "*.slk" \) -mtime +7 -exec rm -f {} \;
```

## Tests recommandés

### Test 1 : Compatibilité avec db_path existant

```bash
# Déployer sur un serveur avec db_path existant
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K --limit server1 -vv

# Vérifier la normalisation
ansible -i inventory.ini server1 -m debug -a "var=db_paths"
# Attendu : db_paths = ["/home/gestcom/dbs"]
```

### Test 2 : Configuration multi-bases

```bash
# Créer host_vars/test-server.yml
cat > host_vars/test-server.yml <<EOF
db_paths:
  - "/home/bases/prod"
  - "/home/bases/dev"
EOF

# Déployer
ansible-playbook -i inventory.ini deploy_gestion_centos6.yml -K --limit test-server

# Vérifier les dossiers créés
ansible -i inventory.ini test-server -m shell -a "find /home/bases -type d -name logos" -b
```

### Test 3 : Script de nettoyage

```bash
# Vérifier le script généré
ansible -i inventory.ini server1 -m shell -a "cat /sos/nettoyage_fichier.sh" -b

# Tester sans supprimer (dry-run)
ansible -i inventory.ini server1 -m shell -a "bash /sos/nettoyage_fichier.sh | head -20" -b
```

## Vérifications post-migration

### Vérifier la normalisation

```bash
# Sur tous les serveurs
ansible -i inventory.ini all -m debug -a "var=db_paths"
ansible -i inventory.ini all -m debug -a "var=db_path"
```

### Vérifier les dossiers créés

```bash
# Vérifier logos
ansible -i inventory.ini all -m shell -a "find /home -type d -name logos -ls" -b

# Vérifier les logs
ansible -i inventory.ini all -m shell -a "ls -la /home/log/" -b
```

### Vérifier le script de nettoyage

```bash
# Afficher les exclusions
ansible -i inventory.ini all -m shell -a "grep -A 3 'Exclusion' /sos/nettoyage_fichier.sh" -b
```

## Fichiers non modifiés (pas nécessaire)

Les fichiers suivants utilisent `db_path` mais n'ont **pas besoin** d'être modifiés :

### Scripts Python
- `roles/install_gestion/files/sqlite/gcinstall_add_version.py`
- `roles/install_gestion/files/sqlite/gcinstall_list_deployments.py`
- `roles/install_gestion/files/csv_to_sqlite.py`

**Raison :** Ces scripts prennent `db_path` comme argument de ligne de commande, pas comme variable Ansible. Ils traitent une base à la fois.

### Inventaires
- `inventaire/emc2.ini`
- `inventaire/gifi_martinique.ini`

**Raison :** Les inventaires utilisent `db_path` (singulier), ce qui est correct. La normalisation automatique les convertit en `db_paths`.

## Impact sur les déploiements existants

### ✅ Aucun impact négatif

- Les configurations existantes continuent de fonctionner
- Aucune modification d'inventaire requise
- Déploiements progressifs possibles

### ✅ Nouvelles possibilités

- Support multi-bases sur un même serveur
- Exclusion de plusieurs chemins du nettoyage
- Configuration plus flexible

## Migration recommandée

### Phase 1 : Validation (optionnel)
- Tester sur serveur de développement
- Vérifier les scripts générés
- Valider les dossiers créés

### Phase 2 : Déploiement progressif
- Déployer sur un sous-ensemble de serveurs
- Monitorer les logs
- Vérifier le nettoyage automatique

### Phase 3 : Déploiement complet
- Déployer sur tous les serveurs
- Migrer les configurations vers `db_paths` si nécessaire

### Phase 4 : Optimisation (si multi-bases)
- Identifier les serveurs nécessitant plusieurs bases
- Migrer leur configuration vers `db_paths` (liste)
- Tester et valider

## Support et documentation

- [Guide complet d'utilisation](DB_PATHS_USAGE.md)
- [Exclusion dans le nettoyage](../roles/system_maintenance/DB_PATHS_EXCLUSION.md)
- [Documentation du rôle system_maintenance](../roles/system_maintenance/README.md)
- [Documentation du rôle logrotate_setup](../roles/logrotate_setup/ReadMe.md)

## Conclusion

La migration vers `db_paths` est **transparente** pour les configurations existantes et apporte **de nouvelles possibilités** pour les cas d'usage multi-bases, sans aucun impact sur les déploiements actuels.
