# Usage: bin/init_centos6_client_to_ansible.sh <IP_ADDRESS_CENTOS6_CLIENT>

#
# Ce script envoie les fichiers à mettre sur une machine cliente
# qui sera configuré par ansible. Le déploiement sur cette machine
# se fera aussi par Ansible.
#
# - création du user administrato
# - installation de python3.11
# 
# Après réception des fichiers par la machine cliente
# - se connecter et lancer le script simple.sh


if [ "$#" -eq 0 ]; then
    echo "Usage: $0 <IP_ADDRESS_CENTOS6_CLIENT>"
    exit 1
fi

HOST_CENTOS6_CLIENT=$1
shift


rm -rf /tmp/ansible_centos6_prep/
mkdir -p /tmp/ansible_centos6_prep/files
cd files
cp  curl-7.76_centos6.v2.tar.bz2 \
    download_files-centos6 \
    emc2-rpms.tar.xz \
    Gestion-centos6-6.06.015aa.tar.xz \
    ncdu_tmux_jq.tar.bz2 \
    openssl-3.2.1_centos6.v2.tar.bz2 \
    python3.11.10-centos6-20250927.tar.xz \
    python3.11.10-centos6-ansible-20250927.tar.xz \
    python3.11.10-centos6-venv-20250927.tar.xz \
    sqlite3_centos6.v2.tar.bz2 \
    venv-python-centos6.tar.xz \
    /tmp/ansible_centos6_prep/files
cd ..
cp ./setup/simple.sh /tmp/ansible_centos6_prep/


scp $@ -r /tmp/ansible_centos6_prep/ gestcom@${HOST_CENTOS6_CLIENT}:/tmp/ansible_centos6_prep 

