# Déploiement de la Gestion Commerciale V6 sur CentOS 6

# Intro

Le déploiement de la Gestion Commerciale V6 (GCV6) sur CentOS 6 peut être réalisé en utilisant Ansible, un outil d'automatisation de configuration. Ce guide explique comment configurer l'environnement nécessaire et exécuter les playbooks Ansible pour installer GCV6.

Ansible assure que GCV6 soit correctement déployé mais aussi que toutes les dépendances et configurations de GCV6 et outils associés soient en place.

**Note :** On parlera ici de machine de contrôle pour la machine où Ansible est installé et de machines cibles pour les machines CentOS 6 où GCV6 sera déployé.

## TL;DR

### Téléchargement et envoie des pré-requis sur serveur

```bash
# Téléchargement de toutes les dépendances centos6 depuis la centos9
./download_files_tui/download_files-centos9 download --osname centos6 -c download_files_tui/config.ini
# Téléchargement du dernier tag de la Gestion centos6 depuis la centos9
./download_files_tui/download_files-centos9 latest --osname centos6 -c download_files_tui/config.ini
# ./download_files_tui/download_files-centos6 -osname centos6
# Envoie des pré-requis d'ansible (user administrator, python...) sur le serveur XXXX
./bin/send_centos6_ansible_init_to_client.sh XXXX

```

### Installation des pré-requis

```bash
ssh gestcom@XXXX
cd /tmp/ansible_centos6_prep
su -c "bash ./simple.sh"
```

### Modifier le mot de passe de administrator

```bash
su -
passwd administrator
```

### Envoie de sa clé SSH

```bash
ssh-copy-id -i ~/.ssh/id_ed25519 administrator@XXX
```

### Modifier le mot de passe de administrator

```bash
su -
passwd administrator
```

## Pré-requis sur les machines cibles

Les machines cibles doivent être accessibles en SSH depuis la machine de contrôle. Il est recommandé d'utiliser des clés SSH pour l'authentification sans mot de passe. Les connexions SSH se feront avec l'utilisateur administrator. Elles aussi avoir une version de python au moins égale à 3.11.
Sur les centos 6, python 3.11 n'est pas disponible dans les dépôts. Il a donc été compilé puis empaqueté dans une archive. Voir la section "Copier Python3.11 sur chaque machine cible" plus bas.

### Créer l'utilisateur `administrator`

```bash
useradd -m -s /bin/bash administrator
passwd administrator
mkdir /home/administrator/.ssh
chmod 700 /home/administrator/.ssh
chown administrator:administrator /home/administrator/.ssh
```

#### Copier Python3.11 sur chaque machine cible

**Créer le fichier ~/.ansible_update.ini** sur la machine de contrôle avec le contenu suivant (à adapter) :

```ini
# Configuration Download Files
[sftp]
host =
user =
pass =
```

Retrouvez ces éléments dans le pass store.

Je vous propose 2 solutions. L'une est à faire sur la machine de contrôle, l'autre sur la machine cible.

1. Télécharger l'archive de Python 3.11 depuis notre ftp.
   ```bash
   cd GCV/ansible
   source .venv/bin/activate
   ./download_python.py download
   ```
2. Copier l'archive sur chaque machine cible
   ```bash
   scp files/python-3.11.0-linux-x86_64.tar.gz administrator@<adresse-ip-de-la-machine-cible>:~/
   ```
3. Décompresser l'archive dans /opt sur chaque machine cible
   ```bash
   ssh administrator@<adresse-ip-de-la-machine-cible>
   su -
   tar xf /home/administrator/python-3.11.10_centos6.v2.tar.bz2 -C /opt
   rm -f /home/administrator/python-3.11.10_centos6.v2.tar.bz2
   chmod -R 755 /opt/python-3.11.10
   ```

## Installer Ansible sur la machine de contrôle

Ansible est à installer sur une machine de contrôle. On peut par exemple l'installer sur la centos 9 d'EMC2. Il est juste nécessaire que cette machine puisse se connecter en SSH aux machines cibles (ici les centos 6), par VPN par exemple.

Voici comment installer Ansible ainsi que les dépendances de notre projet dans un environnement virtuel Python :

```bash
cd GCV/ansible
python3.11 -m venv .venv
source .venv/bin/activate
pip install ansible passlib paramiko typer structlog
```

**Attention :** Si il est **absolument nécessaire** que la machine de contrôle soit _Centos 6_, voici comment installer les dépendances :

```bash
pip install ansible passlib paramiko typer structlog --only-binary cryptography,bcrypt
```

Il ne faut pas essayer de compiler cryptography et bcrypt lors de l'installation.
Sur CentOS 6, certaines dépendances binaires (ex : `cryptography`) peuvent nécessiter `gcc`, `libffi-devel`, `openssl-devel`, etc. Assurez-vous qu'elles sont installées.

## Configurer l'accès SSH aux machines cibles

Ansible utilise SSH pour se connecter aux machines cibles. Il est donc nécessaire de configurer l'accès SSH sans mot de passe en utilisant des clés SSH. Voici comment faire :

Sur chaque machine cible, il faut créer un utilisateur `administrator` dont l'accès aux HOME et fichier SSH doit être restreint à cet utilisateur uniquement. Les droits doivent être 700 pour le dossier .ssh et 600 pour les fichiers à l'intérieur.

```bash
ssh-copy-id administrator@<adresse-ip-de-la-machine-cible>
```

##### Générer votre paire de clés SSH sur la machine de contrôle

Si vous n'avez pas encore de paire de clés SSH, vous pouvez en générer une avec la commande suivante :

```bash
ssh-keygen -t rsa -b 4096 -C "<votre-email@example.com>"
```

##### Copier la clé publique sur chaque machine cible

Utilisez la commande `ssh-copy-id` pour copier votre clé publique sur chaque machine cible. Remplacez

```bash
ssh-copy-id administrator@<adresse-ip-de-la-machine-cible>
```

## Préparer l'inventaire Ansible

À écrire

- [ ] pourquoi indiquer le chemin de la base de données (db_path) ?

# Installation de la gestion via Ansible

## Utilisation avec version spécifique :

```bash
ansible-playbook -i inventaire/ishigo.ini deploy_gestion_centos6.yml -K --ask-vault-pass -e gestion_version=6.06.011ad
```

## Utilisation avec la dernière version :

```bash
ansible-playbook -i inventaire/ishigo.ini deploy_gestion_centos6.yml -K --ask-vault-pass -e gestion_version=last
```

```bash
python3 -m venv venv
source venv/bin/activate
pip install ansible # CentOS 9 et plus

ssh-copy-id admin@192.168.1.27

ansible-playbook -i inventory.ini playbook.yml -K
```

## Déploiement sur la machine locale (sans SSH)

Pour certaines machines non accessibles via SSH, il est possible de déployer GCV6 directement sur la machine qui exécute Ansible. Cette approche est utile quand :

- La machine cible n'a pas de connectivité SSH
- Déploiement sur une machine isolée (connexion via remote desktop par exemple ou bastion)

**Pré-requis pour l'environnement Ansible**.

Sur la centos6, il faut que python 3.11.10 soit installé et que l'environnement virtuel Ansible soit prêt. Le dossier ansible contient un script simple.sh dans le dossier setup/ qui permet de faire cela.

```bash
bash ./setup/simple.sh
```

Il faut au préalable avoir copié le dossier ansible sur la machine. Ceci va créer le user administrator, configurer python 3.11 ainsi que l'environnement virtuel ansible.

### Méthode 1 : Utilisation de l'inventaire localhost

Pour ce qui suit, on suppose que le dossier ansible a été copié sur la machine locale dans `/home/administrator/ansible` après.

1. **Créer un fichier d'inventaire local** `inventory-localhost.ini` :

   ```ini
   [centos6]
   localhost ansible_connection=local

   [centos6:vars]
   ansible_python_interpreter=/home/local/python-3.11.10/bin/python3.11
   db_path="/home/bases/yr"
   ```

1. **Exécuter le déploiement en local** :
   ```bash
   cd /chemin/vers/ansible
   source .venv/bin/activate
   ansible-playbook -i inventory-localhost.ini deploy_gestion_centos6.yml --ask-vault-pass -e gestion_version=last
   ```

### Méthode 2 : Transfer et installation manuelle

Si le dossier ansible a été copié via une interface web ou un média amovible :

1. **Préparer l'environnement** :

```bash
# Sur la machine cible
cd /home/administrator/
tar -xzf ansible-gcv6.tar.gz  # ou copier le dossier via interface web
cd ansible/
python3.11 -m venv .venv
source .venv/bin/activate
pip install ansible passlib paramiko typer structlog
```

2. **Configurer les variables d'environnement** :

```bash
# Créer le fichier d'inventaire local
cp inventory-localhost.ini.example inventory-localhost.ini
# Éditer les variables db_path selon la configuration locale
```

3. **Exécuter le déploiement** :

```bash
ansible-playbook -i inventory-localhost.ini deploy_gestion_centos6.yml --ask-vault-pass -K -e gestion_version=last
```

**-K** : pour demander le mot de passe su root si nécessaire.
**--ask-vault-pass** : pour demander le mot de passe du vault. Le vault contient les éléments sensibles comme le mot de passe de l'utilisateur gestcom.

### Considérations pour le déploiement local

- **Privilèges root** : Le déploiement nécessite des privilèges élevés (sudo/su)
- **Python 3.11** : S'assurer que Python 3.11 est installé avant le déploiement
- **Variables vault** : Le fichier vault.yml doit être accessible avec le bon mot de passe
- **Archives GCV6** : Les archives doivent être présentes dans `roles/install_gestion/files/` ou téléchargées via le script `download_files.py`

# Mot de passe Gestcom dans le Vault Ansible

Le mot de passe de l'utilisateur `gestcom` doit être déplacé dans un fichier chiffré avec Ansible Vault pour des raisons de sécurité. Voici comment procéder.
La variable qui stocke ce mot de passe est `gestcom_passwd`. Dans l'exemple, on suppose que le mot de passe est SuperSecret123.

On va créer un fichier `group_vars/all/vault.yml` pour stocker ce mot de passe de manière sécurisée. Ensuite, on l'utilisera dans les rôles Ansible.

### 1. Génère le hash en clair une fois

#### avec openssl

```bash
openssl passwd -6 SuperSecret123
```

quit retourne :
`$6$mQpWl4kDsE0.PpaC$bB1oUH30ysSykATDf9kRCW/MYp5ZUazertyazertyqJvMIgeqihjaKUFSgFWkMY89SICZ7mfc9FIbWd.`

#### avec Ansible

```bash
ansible -m debug -a "msg={{ 'SuperSecret123' | password_hash('sha512') }}" localhost
```

qui retourne :

```bash
localhost | SUCCESS => {
    "msg": "$6$mQpWl4kDsE0.PpaC$bB1oUH30ysSykATDf9kRCW/MYp5ZUazertyazertyqJvMIgeqihjaKUFSgFWkMY89SICZ7mfc9FIbWd."
}
```

### 2. Crée un fichier `group_vars/all/vault.yml`

```bash
ansible-vault create group_vars/all/vault.yml
```

Et mets-y :

```yaml
gestcom_passwd: "$6$mQpWl4kDsE0.PpaC$bB1oUH30ysSykATDf9kRCW/MYp5ZUazertyazertyqJvMIgeqihjaKUFSgFWkMY89SICZ7mfc9FIbWd."
```

Puis sauvegarde et quitte.

### 4. Utilisation dans un rôle ou playbook

Tu peux l’utiliser comme tu le faisais :

```yaml
password: "{{ gestcom_passwd }}"
```

### 5. Pour modifier le fichier Vault ensuite :

```bash
ansible-vault edit group_vars/all/vault.yml
```

# Troobleshooting

## Erreur de connexion SSH

```
fatal: [co6extern]: UNREACHABLE! => {"changed": false, "msg": "Failed to connect to the host via ssh: administrator@192.168.1.115: Permission denied (publickey,password,keyboard-interactive).", "unreachable": true}
```

## Warnings de transfert SFTP/SCP

```
[WARNING]: sftp transfer mechanism failed on [192.168.1.5]. Use ANSIBLE_DEBUG=1 to see detailed information
[WARNING]: scp transfer mechanism failed on [192.168.1.5]. Use ANSIBLE_DEBUG=1 to see detailed information
```

Ces warnings apparaissent sur les systèmes CentOS 6 car les méthodes de transfert SFTP et SCP échouent, obligeant Ansible à utiliser la méthode `piped` (plus lente mais fonctionnelle). Cela est dû aux anciennes versions d'OpenSSH sur CentOS 6 qui ne supportent pas pleinement les protocoles modernes. Les transferts de fichiers fonctionnent malgré tout, ces warnings peuvent être ignorés.

# Tips

### Visualiser la liste des versions déployées

Se rendre sur le serveur distant

```bash
activate_python311
sqlite3 /home/local/etc/.gcv6/deployments.db "SELECT * FROM deployments;"
deactivate_python311
```

# Troubleshooting

## An unknown error occurred: name 'ssl' is not defined

Il faut charger la variable d'environnement SSLDIR sur la cible avant d'exécuter Ansible.
