"""
Configuration pytest et fixtures pour les tests du plugin Kiabi.
"""

import pytest
from pathlib import Path
from datetime import datetime
from io import StringIO


@pytest.fixture
def sample_csv_content():
    """
    Contenu CSV d'exemple pour les tests.

    Returns
    -------
    str
        Contenu CSV avec header et 4 lignes de données
    """
    return """Shop_id;Invoice_id;Invoice_date;Order_id;Order_ref;Customer_lastname;Customer_firstname;Loyalty_card_id;Loyalty_discount_flag;Product_id;Product_name;Product_ref;Product_ean13;Product_unit_price_ht;Product_unit_price_ttc;Product_tax_rate;Product_qty;Product_total_price_ht;Product_total_price_ttc;Product_stock_shop_id;Invoice_product_ht;Invoice_tax;Invoice_product_ttc;Payment_method;Payment_amount;Payment_transaction_id;Payment_bank_remittance_date;Invoice_reduction_ttc;Currency;CurrencyRateEur;Voucher_id_1;Voucher_amount_1;Voucher_id_2;Voucher_amount_2;Voucher_id_3;Voucher_amount_3
123;100001;2025-01-15 14:30:25;1001;ORD001;DUPONT;Jean;1234567890;1;P001;T-Shirt Bleu;TSH001;3456789012345;15.83;19.00;20.00;2;31.66;38.00;123;31.66;6.34;38.00;Paiement CB;38.00;123-TRX001;2025-01-16;0.00;EUR;1.0;;;;
123;100002;2025-01-15 15:45:10;1002;ORD002;MARTIN;Sophie;9876543210;0;P002;Pantalon Noir;PAN001;9876543210987;41.67;50.00;20.00;1;41.67;50.00;123;91.67;18.33;110.00;Paiement CB;90.00;123-TRX002;2025-01-16;20.00;EUR;1.0;AVOIR001;20.00;;
123;100002;2025-01-15 15:45:10;1002;ORD002;MARTIN;Sophie;9876543210;0;P003;Veste Grise;VES001;1122334455667;50.00;60.00;20.00;1;50.00;60.00;123;91.67;18.33;110.00;Paiement CB;90.00;123-TRX002;2025-01-16;20.00;EUR;1.0;AVOIR001;20.00;;
456;100003;2025-01-16 10:20:30;1003;ORD003;BERNARD;Pierre;;0;P004;Chaussures Sport;CHA001;2233445566778;70.83;85.00;20.00;1;70.83;85.00;456;70.83;14.17;85.00;Paiement CB;50.00;456-TRX003;2025-01-17;35.00;EUR;1.0;AVOIR002;20.00;AVOIR003;15.00
"""


@pytest.fixture
def sample_csv_file(tmp_path, sample_csv_content):
    """
    Crée un fichier CSV temporaire pour les tests.

    Parameters
    ----------
    tmp_path : Path
        Répertoire temporaire fourni par pytest
    sample_csv_content : str
        Contenu CSV de la fixture

    Returns
    -------
    Path
        Chemin vers le fichier CSV temporaire
    """
    csv_file = tmp_path / "test_invoice.csv"
    csv_file.write_text(sample_csv_content, encoding="utf-8")
    return csv_file


@pytest.fixture
def sample_row_dict():
    """
    Dictionnaire représentant une ligne CSV parsée.

    Returns
    -------
    dict
        Ligne CSV sous forme de dictionnaire
    """
    return {
        "Shop_id": "123",
        "Invoice_id": "100001",
        "Invoice_date": "2025-01-15 14:30:25",
        "Order_id": "1001",
        "Order_ref": "ORD001",
        "Customer_lastname": "DUPONT",
        "Customer_firstname": "Jean",
        "Loyalty_card_id": "1234567890",
        "Loyalty_discount_flag": "1",
        "Product_id": "P001",
        "Product_name": "T-Shirt Bleu",
        "Product_ref": "TSH001",
        "Product_ean13": "3456789012345",
        "Product_unit_price_ht": "15.83",
        "Product_unit_price_ttc": "19.00",
        "Product_tax_rate": "20.00",
        "Product_qty": "2",
        "Product_total_price_ht": "31.66",
        "Product_total_price_ttc": "38.00",
        "Product_stock_shop_id": "123",
        "Invoice_product_ht": "31.66",
        "Invoice_tax": "6.34",
        "Invoice_product_ttc": "38.00",
        "Payment_method": "Paiement CB",
        "Payment_amount": "38.00",
        "Payment_transaction_id": "123-TRX001",
        "Payment_bank_remittance_date": "2025-01-16",
        "Invoice_reduction_ttc": "0.00",
        "Currency": "EUR",
        "CurrencyRateEur": "1.0",
        "Voucher_id_1": "",
        "Voucher_amount_1": "",
        "Voucher_id_2": "",
        "Voucher_amount_2": "",
        "Voucher_id_3": "",
        "Voucher_amount_3": "",
    }


@pytest.fixture
def sample_row_dict_with_vouchers():
    """
    Dictionnaire représentant une ligne CSV avec vouchers.

    Returns
    -------
    dict
        Ligne CSV avec vouchers sous forme de dictionnaire
    """
    return {
        "Shop_id": "456",
        "Invoice_id": "100003",
        "Invoice_date": "2025-01-16 10:20:30",
        "Order_id": "1003",
        "Order_ref": "ORD003",
        "Customer_lastname": "BERNARD",
        "Customer_firstname": "Pierre",
        "Loyalty_card_id": "",
        "Loyalty_discount_flag": "0",
        "Product_id": "P004",
        "Product_name": "Chaussures Sport",
        "Product_ref": "CHA001",
        "Product_ean13": "2233445566778",
        "Product_unit_price_ht": "70.83",
        "Product_unit_price_ttc": "85.00",
        "Product_tax_rate": "20.00",
        "Product_qty": "1",
        "Product_total_price_ht": "70.83",
        "Product_total_price_ttc": "85.00",
        "Product_stock_shop_id": "456",
        "Invoice_product_ht": "70.83",
        "Invoice_tax": "14.17",
        "Invoice_product_ttc": "85.00",
        "Payment_method": "Paiement CB",
        "Payment_amount": "50.00",
        "Payment_transaction_id": "456-TRX003",
        "Payment_bank_remittance_date": "2025-01-17",
        "Invoice_reduction_ttc": "35.00",
        "Currency": "EUR",
        "CurrencyRateEur": "1.0",
        "Voucher_id_1": "AVOIR002",
        "Voucher_amount_1": "20.00",
        "Voucher_id_2": "AVOIR003",
        "Voucher_amount_2": "15.00",
        "Voucher_id_3": "",
        "Voucher_amount_3": "",
    }
