__version__ = "1.0"

from pathlib import Path

import numpy as np
import pandas as pd


class Tickets:

    def __init__(self, filepath, sep=";", encoding="cp850"):
        self.sep = sep
        self.filepath = filepath
        self.encoding = encoding
        self._df = None
        assert Path(filepath).is_file(), f"Le fichier {filepath} n'existe pas"

    def read_tickets(self):
        """Lis le fichier filename et retourne un DataFrame des lignes de facture."""

        filepath = self.filepath
        sep = self.sep
        encoding = self.encoding

        # FIXME! Verifier que la structure du CSV n'a pas changé
        df = pd.read_csv(
            filepath, sep=sep, encoding=encoding,
            header=0, index_col=False,
            dtype={ "client":str, "numcrt":str, "numdep":int, "code art.":str, "barcode":str} | {f"fam. {i}p":str for i in range(1,5)}
            )

        # Modifier chaque cellule de la dataframe pour supprimer les espaces supplémentaires
        df = df.map(lambda x: x.strip() if isinstance(x, str) else x)
        df["dtfac"] = pd.to_datetime(df["dtfac"], format="%Y%m%d%H:%M:%S", errors="coerce")
        df.replace({"nan": None, np.nan:None}, inplace=True)

        self._df = df

    def get_ticket(self, numero):
        return self._df[ self._df["nofac"] == numero ]

    def to_csv(self, csvpath, numero=None,
               sep=None, encoding=None,
               quotechar=None,
               linedeliminator=None
               ):

        # Parametre pour la fonction to_csv de pandas
        kwargs_to_csv = {
            "delimiter" : sep or self.sep,
            "encoding": encoding or self.encoding,
            "index":False
        }
        if numero is None :
            self._df.to_csv(csvpath, **kwargs_to_csv)
        else:
            self.get_ticket(numero).to_csv(csvpath, **kwargs_to_csv)


    # def read_tickets_group_by_article(filepath, sep=';', encoding="cp850"):
    #     """Groupe les lignes de facture par article et retourne un DataFrame."""

    #     df = read_tickets(filepath, sep, encoding)
    #     df = df.groupby(["code art.", "desig. art."], as_index=False).agg(
    #         {"quantity": np.sum, "PU TTC": np.mean, "Total TTC": np.sum, "Mont. fac TTC": np.sum}
    #     )
    #     return df

    # def read_tickets_group_by_nofac(filepath, sep, encoding):
    #     """Groupe les lignes de facture par numero de facture et retourne un DataFrame."""

    #     df = read_tickets(filepath, sep, encoding)
    #     df = df.groupby(["nofac"], as_index=False).agg(
    #         {"Total TTC": np.sum, "Mont. fac TTC": np.mean}
    #     )
    #     return df

