import json
import subprocess
import re
import sys

confJSON = "plugins/etiquettes/gifi.json"
with open(confJSON) as fp:
    etiquettes_societe = json.load(fp)


from simple_term_menu import TerminalMenu

def choix_model():
    options = etiquettes_societe["etiquettes"]
    if len(options)==1:
        return options[0]

    terminal_menu = TerminalMenu([opt["nom"] for opt in options])
    menu_entry_index = terminal_menu.show()
    return options[menu_entry_index]

def choix_papier(model):
    if len(model["papiers"])==1:
        return model["papiers"][0]

    options = model["papiers"]
    terminal_menu = TerminalMenu(options)
    menu_entry_index = terminal_menu.show()
    return options[menu_entry_index]


def choix_tailles(model):
    if len(model["tailles"]) == 1:
        return model["tailles"]

    terminal_menu_multi = TerminalMenu(
        model["tailles"],
        multi_select=True,
        show_multi_select_hint=True,
    )

    menu_entry_indices = terminal_menu_multi.show()

    print(menu_entry_indices)
    return terminal_menu.chosen_menu_entries


def choix_modele_as_gcv6():
    etiquettes = etiquettes_societe["etiquettes"]
    modeles, options = [], []
    for etiquette in etiquettes:
        prefix = etiquette["display_nom"]
        modele = etiquette["modelePy"]
        for cat in etiquette["categories"]:
            for taille in etiquette["tailles"]:
                options.append("{0} ({1}) ({2})".format(prefix, cat, taille))
                modeles.append(modele)
    if len(options)==1:
        return options[0], modeles[0]

    terminal_menu = TerminalMenu(options)
    menu_entry_index = terminal_menu.show()
    return options[menu_entry_index], modeles[menu_entry_index]


with open("exemples/etiquettes.json") as fp:
    gcv6 = json.load(fp)



if __name__ == "__main__":
    choix, modele = choix_modele_as_gcv6()
    matched = re.match("(?P<modeleDP>.*) \((?P<cat>.*)\).*\((?P<taille>.*)\)", choix)
    if matched:
        # Obtenir le modele a utiliser (Attention ! C’est le nom lisible par l’utilisateur mais non celui utilisable par Python)
        modeleDP = matched.group("modeleDP").strip()
        categorie = matched.group("cat")
        taille = matched.group("taille")
        papier = "a4"

        # print(modele, modeleDP)
        # print("Vous avez sélectionné", modeleDP, categorie, taille, papier)
    else:
        sys.exit(0)

    gcv6["modele"] = modeleDP
    gcv6["papersize"] = papier
    for article in gcv6["articles"]:
        article["taille"] = taille
        article["categorie"] = categorie

    with open("gcv6_test.json", "w", encoding="cp850") as fp:
        json.dump(gcv6, fp, indent=2)

    # print("pipenv run python3 bin/etiquettes -j gcv6_test.json --model {0}".format(modele))
    # subprocess.call("pipenv run python3 bin/etiquettes -j gcv6_test.json --model {0}".format(modele).split())

    system_cmd = "pipenv run python3 bin/etiquettes -j gcv6_test.json --confJSON {0}".format(confJSON)
    print(system_cmd)
    subprocess.call(system_cmd.split())
