from pathlib import Path

def is_centos6() -> bool:
    """
    Détecte si l'environnement d'exécution est un système CentOS 6.

    Returns
    -------
    bool
        True si le système est CentOS 6, sinon False.
    """
    redhat_release = Path("/etc/redhat-release")
    if redhat_release.is_file():
        content = redhat_release.read_text().strip().lower()
        return "centos release 6" in content
    return False
