from gescokit.pyisql import select_crtf_cli_by_cardnumber, get_ville, client_is_crtf_and_actif

def get_town_by_zip(zipcode):
    nbrows, data = get_ville(zipcode)
    if nbrows > 0:
        return data[0]["nom"]
    return ""

def is_valid_customer(cardnumber):
    nbrows, cli = select_crtf_cli_by_cardnumber(cardnumber, is_actif=True)
    return nbrows == 1 and cli.get("code") != cli.get("numcrt")

def get_client_data(cardnumber):
    _, client = select_crtf_cli_by_cardnumber(cardnumber, is_actif=True)
    return client

def is_crtf_and_active_client(code_client):
    return client_is_crtf_and_actif(code_client)
