import subprocess

def check_lualatex_installed() -> bool:
    """Vérifie si LuaLaTeX est installé."""
    try:
        subprocess.run(["lualatex", "--version"], check=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
        return True
    except (subprocess.CalledProcessError, FileNotFoundError):
        return False

def check_arara_installed() -> bool:
    """Vérifie si Arara est installé."""
    try:
        subprocess.run(["arara", "--version"], check=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
        return True
    except (subprocess.CalledProcessError, FileNotFoundError):
        return False

def check_pdftocairo_installed() -> bool:
    """Vérifie si pdftocairo est installé."""
    try:
        subprocess.run(["pdftocairo", "-v"], check=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
        return True
    except (subprocess.CalledProcessError, FileNotFoundError):
        return False