import csv

def lire_ligne_fixe(ligne):
    i = 0

    def lire(n):
        nonlocal i
        val = ligne[i:i+n]
        i += n
        return val.strip()

    data = {
        'centrale': lire(10),
        'magasin': lire(10),
        'date': lire(4) + '-' + lire(2) + '-' + lire(2),
        'nb_clients': int(lire(6)),
        'nb_articles': int(lire(10)),
        'ventes_brutes': float(lire(15)) / 1000.0,
        'ventes_nettes': float(lire(15)) / 1000.0,
        'divers': lire(15),
        'frais': lire(15),
        'tva_collectee': float(lire(15)) / 1000.0,
        'devise': lire(3),
        'cours_devise': float(lire(12)) / 1000000.0,
        'etat': lire(30).strip()
    }

    return data


def lire_fichier_fixe(nom_fichier):
    lignes_data = []
    with open(nom_fichier, 'r', encoding='utf-8') as f:
        for ligne in f:
            if ligne.strip():
                lignes_data.append(lire_ligne_fixe(ligne.rstrip('\n')))
    return lignes_data


def exporter_csv(donnees, nom_fichier_csv):
    if not donnees:
        print("Aucune donnée à écrire.")
        return

    with open(nom_fichier_csv, 'w', newline='', encoding='utf-8') as csvfile:
        writer = csv.DictWriter(csvfile, fieldnames=donnees[0].keys())
        writer.writeheader()
        writer.writerows(donnees)

    print(f"Export CSV terminé : {nom_fichier_csv}")


# Exemple d’utilisation
if __name__ == "__main__":
    fichier_texte = "mon_fichier.txt"
    fichier_csv = "export.csv"

    resultats = lire_fichier_fixe(fichier_texte)
    exporter_csv(resultats, fichier_csv)
