from gescokit.api.gifi.base import FixedWidthParser
from typing import Any

description = """Flux E2 – Remontées des Ventes magasin

Ce fichier contient les informations des ventes quotidiennes (détaillées au ticket de caisse)
des points de vente du client. Ce niveau de détail est important pour la pertinence des propositions
des commandes de réassort.
Mise à disposition 1,1 fichier E2 dans le répertoire d’échange SFTP 'Export' dédié au client.
Le fichier Flux E2 est obligatoire et doit être accompagné du fichier Flux E1 (Ventes : Chiffre d’affaires)."""


class Jrap1Parser(FixedWidthParser):
    """
    Parser pour le fichier JRAP1 (ventes détaillées par ticket).

    Structure conforme au cahier des charges fourni par GiFi.
    """

    version = "1.3.6"
    label = description
    filename = "tcxjrap1.dat"
    flux_code = "E2"
    flux_name = "Ventes magasin détaillées"
    flux_type = "JRAP1"
    encoding = "utf-8"

    fields: list[tuple[str, int | tuple[int, Any]]] = [
        ("client_id", 10),
        ("store_id", 10),
        ("sale_date", 8),
        ("sale_time", 6),
        ("register_id", 3),
        ("ticket_id", 6),
        ("article_id", 13),
        ("operation_sign", 1),
        ("quantity", (10, lambda s: int(s) / 1000)),
        ("unit", 1),
        ("unit_price", (13, lambda s: int(s) / 1000)),
        ("currency", 3),
        ("exchange_rate", (12, lambda s: int(s) / 1_000_000)),
        ("gross_total", (13, lambda s: int(s) / 1000)),
        ("net_total", (13, lambda s: int(s) / 1000)),
        ("short_label", 20),
        ("category_code", 3),
        ("universe_code", 3),
        ("range_code", 3),
        ("is_local_product", 1),
        ("vat_rate", (5, lambda s: int(s) / 100)),
        ("line_number", 5),
        ("purchase_price", (13, lambda s: int(s) / 1000)),
        ("cost_price", (13, lambda s: int(s) / 1000)),
    ]

    metadata: dict[str, dict[str, Any]] = {
        "client_id": {"fullname": "N° client", "description": "Code client assigné par GiFi", "obligatoire": True},
        "store_id": {"fullname": "N° magasin", "description": "Code magasin du client", "obligatoire": True},
        "sale_date": {"fullname": "Date de vente", "description": "Format AAAAMMJJ", "obligatoire": True},
        "sale_time": {"fullname": "Heure de vente", "description": "Format HHMMSS", "obligatoire": True},
        "register_id": {"fullname": "N° de caisse", "obligatoire": True},
        "ticket_id": {"fullname": "N° de ticket", "obligatoire": True},
        "article_id": {"fullname": "Code article", "description": "Code article EAN13"},
        "quantity": {"fullname": "Quantité", "description": "Quantité vendue, exprimée en millier"},
        "unit_price": {"fullname": "Prix unitaire TTC", "description": "En euros"},
        "gross_total": {"fullname": "Total TTC brut"},
        "net_total": {"fullname": "Total TTC net après remise"},
        "vat_rate": {"fullname": "Taux TVA", "description": "Taux exprimé en %"},
    }
