#!/bin/bash
# Ce script accepte une archive en parametre, vrifie son existence,
# la dcompresse, puis cre des liens symboliques.

INSTALL_PREFIX="/home/local/bin"
CONFIGDIR=$INSTALL_PREFIX/../etc/.gcv6


# Vrifier si l'utilisateur actuel est 'gestcom'
if [ "$(whoami)" != "gestcom" ]; then
    echo "Seul gestcom peut lancer ce script."
    exit 3
fi


# Differente methode pour obtenir la version de CentOS
# full=`cat /etc/centos-release | tr -dc '0-9.'`
centos_major=$(cat /etc/centos-release | tr -dc '0-9.'|cut -d \. -f1)
# minor=$(cat /etc/centos-release | tr -dc '0-9.'|cut -d \. -f2)
# asynchronous=$(cat /etc/centos-release | tr -dc '0-9.'|cut -d \. -f3)


if [ $centos_major -ne 6 ]; then
  echo "Ce script est destin UNIQUEMENT  CentOS 6. Vous utilisez CentOS $centos_major."
  exit 1
fi


# Vrification du nombre d'arguments
if [ "$#" -ne 1 ]; then
    echo "Usage: $0 fichier_archive"
    exit 1
fi

STEP=0
echo_etape()
{
  STEP=$((STEP+1))
  echo "etape: $STEP " $@
}

ARCHIVE="$1"

# Vrification de l'existence du fichier
if [ ! -f "$ARCHIVE" ]; then
    echo "Erreur : le fichier '$ARCHIVE' n'existe pas."
    exit 1
fi


echo_etape "Dcompression de l'archive"
# On suppose qu'il s'agit d'une archive tar (par exemple tar.gz ou tar.bz2)
tar -xf "$ARCHIVE" || { echo "Erreur lors de la décompression de $ARCHIVE"; exit 1; }


echo_etape "Recherche du nom de dossier"
# Détermination du dossier extrait
# On suppose que l'archive contient un répertoire racine unique.
DOSSIER=$(tar -tf "$ARCHIVE" | head -n 1 | cut -d/ -f1)
if [ -z "$DOSSIER" ] || [ ! -d "$DOSSIER" ]; then
    echo "Erreur : impossible de trouver le dossier extrait."
    exit 1
fi

now=$(date +%Y%m%d)

echo_etape "Configure les dossiers necessaire"

if [ ! -d "$INSTALL_PREFIX" ]; then
  echo "Erreur : le dossier $INSTALL_PREFIX n'existe pas."
  echo "Veuillez le crer manuellement."
  echo "mkdir -p $INSTALL_PREFIX"
  echo "chown -R gestcom:gestcom $INSTALL_PREFIX"
  echo "chmod -R 755 $INSTALL_PREFIX"
  exit 1
fi

mkdir -p $CONFIGDIR
mkdir -p /home/{gcv6,gestcom}/logs/daily

FULLPATH="$INSTALL_PREFIX/$DOSSIER"
INSTALLDIR="$INSTALL_PREFIX/$DOSSIER"
if [ -d "$FULLPATH" ]; then
  # Deplacer ancien deploiement de la meme version
  echo "ATTENTION ! cette version a deja ete installe. Je la deplace"
  mv "$FULLPATH" "$FULLPATH.$now"
  echo "$FULLPATH -> $FULLPATH.$now"
fi

echo_etape "Deplace le dosier $DOSSIER dans $INSTALL_PREFIX"
mv $DOSSIER $INSTALL_PREFIX


echo_etape "Controle de la presence de l'ancien mode de fonctionnemennt"
# Préparer la gestion à la nouvelle structure du déploiement
if [ ! -f $CONFIGDIR/deploiement.csv ]; then
  for user in gcv6 gestcom; do
    echo "Deplacement des anciennes versions de GCV6 (les fichiers old*)"
    mkdir -p /home/$user/GCV6-old/bin
    mv /home/$user/old* /home/$user/GCV6-old/bin
    #mv /home/$user/undepp.sh /home/$user/depp.sh /home/$user/GCV6-old/
  done
  echo "GCV6-old;$now" > $CONFIGDIR/deploiement.csv
fi




# Vérifier que je suis dans /home/gestcom
cd $INSTALL_PREFIX
# Création des liens symboliques dans le répertoire courant
echo_etape "Cration des liens symboliques dans /home/gestcom"
ln -sf $INSTALLDIR/txt/bin/* /home/gestcom/

# Cration des liens symboliques dans /home/gestcom
echo_etape "Cration des liens symboliques dans /home/gcv6"
ln -sf $INSTALLDIR/gtk2/bin/* /home/gcv6/

# Ajout de la version dploye en premire position
echo_etape "Ajout de la version dploye en premire position"
echo "$DOSSIER;$now" > $CONFIGDIR/deploiement.csv
sed -i "1s/^/$DOSSIER;$now\n/" $CONFIGDIR/deploiement.csv
# Suppression des doublons de versions
awk -F';' '!seen[$1]++' $CONFIGDIR/deploiement.csv > $CONFIGDIR/deploiement.csv.tmp && mv $CONFIGDIR/deploiement.csv.tmp $CONFIGDIR/deploiement.csv


# Rechercher tous les dossiers au format {ROOTDIR}.YYYYMMDD et demander confirmation pour suppression
for dir in "$INSTALL_PREFIX/$DOSSIER.*"; do
  if [[ -d "$dir" && "$dir" =~ $INSTALL_PREFIX/$DOSSIER\.[0-9]{8}$ ]]; then
    echo "Voulez-vous supprimer le dossier $dir ? (o/n) : "
    read -r response
    if [[ "$response" == "o" ]]; then
      rm -rf "$dir"
      echo "Dossier $dir supprim."
    else
      echo "Dossier $dir conserv."
    fi
  fi
done

echo "Script termin avec succs."
