"""
Formatters - Interface vers le système de destinations
"""
from app.destinations import get_all_formatters

# Importer tous les formatters des destinations
FORMATTERS = get_all_formatters()


def get_formatter(formatter_name: str):
    """
    Récupère un formatter par son nom

    Args:
        formatter_name: Nom du formatter

    Returns:
        Fonction formatter ou None si non trouvé
    """
    return FORMATTERS.get(formatter_name)
