# Template pour nouvelle destination

Ce template vous permet de créer rapidement une nouvelle destination pour le middleware.

## Étapes pour créer une nouvelle destination

### 1. Créer le dossier de la destination

```bash
cd destinations/
mkdir ma_nouvelle_destination
cd ma_nouvelle_destination
```

### 2. Copier les fichiers du template

```bash
cp ../template/__init__.py.template __init__.py
cp ../template/destination.py.template destination.py
cp ../template/formatters.py.template formatters.py
cp ../template/config.py.template config.py

# Optionnel si vous avez besoin de validateurs
cp ../template/validators.py.template validators.py
```

### 3. Éditer les fichiers

#### `__init__.py`
Remplacez `MyDestination` par le nom de votre classe.

#### `destination.py`
- Remplacez `my_destination` par l'identifiant unique de votre destination
- Configurez vos APIs dans `get_api_configs()`
- Définissez vos routes dans `get_routes()`
- Ajustez la description et la version

#### `formatters.py`
- Créez vos fonctions de formatage
- Ajoutez-les au dictionnaire `FORMATTERS`

#### `config.py` (optionnel)
- Ajoutez votre configuration TOML si nécessaire
- Gérez le chargement de vos paramètres

#### `validators.py` (optionnel)
- Créez vos validateurs Pydantic
- Ajoutez-les au dictionnaire `VALIDATORS`

### 4. Tester la destination

```bash
# Retour à la racine du middleware
cd ../../

# Démarrer le serveur
uvicorn main:app --reload

# Vérifier que votre destination est chargée
curl http://localhost:8000/destinations
```

### 5. Utiliser la destination

Envoyez une requête avec un `event_type` correspondant à une de vos routes :

```bash
curl -X POST http://localhost:8000/submit \
  -H "Content-Type: application/json" \
  -d '{
    "event_type": "mon_event",
    "data": {
      "message": "Test"
    }
  }'
```

## Structure minimale requise

Une destination doit obligatoirement implémenter :

- `get_name()` : nom unique de la destination
- `get_api_configs()` : au moins une API
- `get_routes()` : au moins une route
- `get_formatters()` : au moins un formatter

Optionnel :
- `get_validators()` : validateurs Pydantic
- `get_description()` : description de la destination
- `get_version()` : version de l'implémentation
- `is_enabled()` : pour activer/désactiver dynamiquement

## Exemple de destination simple

Voir les destinations existantes :
- `fne_cdi/` : exemple complet avec validateurs
- `test_apis/` : exemple simple sans validateurs

## Bonnes pratiques

1. **Nommage** : utilisez des noms en snake_case pour les identifiants
2. **Documentation** : documentez chaque formatter et validator
3. **Tests** : créez des tests unitaires pour vos formatters
4. **Configuration** : externalisez les secrets dans `config.toml`
5. **Versioning** : incrémentez la version à chaque modification
6. **Validation** : utilisez Pydantic pour valider les données entrantes
