# /bin/env python3

import argparse
from datetime import date
import os
from pathlib import Path
import shutil
import sys
from zipfile import ZipFile

from gescokit import gcvarchiver
from gescokit.gcvarchiver.tools import get_centos_release
from gescokit.gcvarchiver.tools import verifier_checksum

# Vérifier la version Python est au moins égale à 3.4
if sys.version_info.major < 3:
    raise SystemError(
        "Version Python non prise en charge. Veuillez utiliser une version au moins égale à 3.4."
    )
if sys.version_info.minor < 4:
    raise SystemError(
        "Version Python non prise en charge. Veuillez utiliser une version au moins égale à 3.4."
    )


# try:
#   import pandas as pd
#   from arch_functions_with_pandas import *
# except:
#   from arch_functions import *
from gescokit.gcvarchiver import *


def definir_les_arguments():
    parser = argparse.ArgumentParser(description="Sortir l'archive en format html")

    parser.add_argument("--idvent", type=int, help="numéro de vente")
    parser.add_argument("--periode", type=int, help="période: 1:journalier, 2:mensuel", choices=[1,2])
    parser.add_argument("--dtbatch", help="date du batch YYYYMMDD")
    parser.add_argument("--idbase", type=int, help="identifiant de la base")
    parser.add_argument(
        "-f",
        "--zipfile",
        help="chemin vers le fichier zip de type archive_001YYYYMMDD.zip",
        required=True,
    )

    return parser.parse_args()


if __name__ == "__main__":
    # Pour python 3.4 et 3.5, il faut convertir les Path en str
    # car la fonction open ne supporte pas les Path
    if sys.version_info.minor <= 6:
        orig_open = open
        open = lambda x, *args, **kwargs: orig_open(str(x), *args, **kwargs)

    # ------- Définir les paramètres d'exécution du programme
    #         il faut idvent, periode, dtbatch et idbase.
    # Ces paramètres sont soit donnés en argument soit devinés
    # en exploitant le fichier zip.
    # _______________________________________________________________
    args = definir_les_arguments()

    zippath = Path(args.zipfile)

    if not zippath.is_file():
        raise FileNotFoundError("Impossible de trouver le fichier zip")

    root = zippath.absolute().parent.resolve()

    SHAERROR, SHAINFO = verifier_checksum(zippath)

    if args.zipfile:
        # Devinez la date à partir du fichier
        date_txt = zippath.stem.split("_")[1][-8:]

        idvent, idbase = 1, 1
    else:
      idvent, periode, idbase, date_txt = args.idvent, args.periode, args.idbase, args.dtbatch

    # Extraction du fichier zip
    output = Path("output")
    if output.is_dir():
        shutil.rmtree(output)
    ZipFile(str(zippath)).extractall(path=str(output))

    if args.zipfile:
        # Deviner la periode.
        if list(output.glob("*archive_jetmens.csv")):
            periode = 2
        else:
            periode = 1

    periode_name = "Jour" if periode == 1 else "Mois"

    dtarch, dtsyst = date_txt, date_txt

    # Déterminer l'encodage en fonction de la version de centos
    # encoding = "cp850" if get_centos_release()==6 else 'utf-8'
    encoding = "cp850"
    HTML_ENCODING = "utf-8"

    html_file_tmp = Path("test.tmp")
    navbar = []
    html = ""
    # FIXME ! Déplacer la partie with tout en bas
    with open(str(html_file_tmp), "w", encoding=HTML_ENCODING) as fp:
        if periode == 2:
            navigations, txt = archive_gtotalmens(idvent, date_txt)
            if txt:
                html += txt
                navbar.extend(navigations)

        if encoding == "cp850":
            print("Encoding:", encoding)
            navigations, txt = archive_gtt(idvent, date_txt, periode, encoding)
        else:
            navigations, txt = archive_gtt(idvent, date_txt, periode)
        if txt:
            html += txt
            navbar.extend(navigations)

        if periode == 1:
            # if (xmlNewChild_archive_facture    (root_node, idvent, periode, dtbatch) == 0) exit (1);
            navigations, txt = archive_facture(idvent, date_txt)
            if txt:
                html += txt
                navbar.extend(navigations)

            navigations, txt = archive_complement(idvent, date_txt)
            if txt:
                html += txt
                navbar.extend(navigations)

            # if (xmlNewChild_archive_lignes  (root_node, idvent, periode, dtbatch) == 0) exit (1);
            navigations, txt = archive_lignes(idvent, date_txt)
            if txt:
                html += txt
                navbar.extend(navigations)

            # if (xmlNewChild_archive_dupl    (root_node, idvent, periode, dtbatch) == 0) exit (1);
            navigations, txt = archive_dupl(idvent, date_txt)
            if txt:
                html += txt
                navbar.extend(navigations)

        # if (xmlNewChild_archive_jet (root_node, idbase, periode, dtbatch) == 0) exit (1);
        navigations, txt = archive_jet(idbase, date_txt, periode)
        if txt:
            html += txt
            navbar.extend(navigations)

        navigations, txt = archive_emetteur(idbase, date_txt)
        if txt:
            html += txt
            navbar.extend(navigations)

        print(html, file=fp)

    html_file = str(
        root / "archive_{:03}{}_{}.html".format(idvent, date_txt, periode_name)
    )

    open_html(html_file, navbar, (SHAERROR, SHAINFO))
    html = ""
    with open(html_file, "a", encoding=HTML_ENCODING) as fp:
        print("<h1>Archive fiscal </h1>", file=fp)
        print("<h3>Période : {}</h3><h3>Date: {}</h3>".format(periode_name, dtarch), file=fp)
        print(
            "<h4>Archive html générée le {:%d-%m-%Y} à partir d'archive zip créée le {}</h4>".format(
                date.today(), dtarch
            ),
            file=fp,
        )

    with open(str(html_file_tmp), encoding=HTML_ENCODING) as ip, open(
        html_file, "a", encoding=HTML_ENCODING
    ) as fp:
        for line in ip.readlines():
            print(line, file=fp, end="")

    close_html(html_file)

    print("Archive générée dans:", html_file)

    html_file_tmp.unlink()

    shutil.rmtree("output")
