#!/opt/venv/bin/python3

# https://mailgun-docs.redoc.ly/docs/mailgun/api-reference/openapi-final/tag/Messages/#tag/Messages/operation/POST-v3--domain-name--messages


import configparser
import os
from pathlib import Path
import requests

DBPATH = Path(os.getenv("DBPATH"))
if not DBPATH.is_dir():
    raise FileNotFoundError(f"Le répertoire {DBPATH} n'existe pas.")

inifile = DBPATH / 'config/gcv6_config.ini'
if not inifile.is_file():
    raise FileNotFoundError(f"Le fichier {inifile} n'existe pas.")

config = configparser.ConfigParser()
config.read(str(inifile))
# Accéder aux paramètres dans la section rapport.tcxartp2
section = "rapport.tcxartp2"

mailgun_apikey = config[section]["mailgun_apikey"]
mailgun_domain = config[section]["mailgun_domain"]
mailgun_url = config[section]["mailgun_url"]
mailgun_from = config[section]["mailgun_from"]
destinataires = config[section]["destinataires"].split(",")
emc2_destinataires = config[section]["emc2_destinataires"].split(",")



def send_email_with_attachment(attachment_path):

    # Contenu de l'email
    subject = "Rapport d'intégration tcxarpt2"
    text_content = "Bonjour,\n\nVeuillez trouver ci-joint le rapport d'intégration tcxarpt2 au format CSV.\n\nCordialement.\nGCV6\n\nCet e-mail est envoyé automatiquement par la gestion commeciale."
    html_content = "<body><p>Bonjour</p><p></p><p>Veuillez trouver ci-joint le rapport d'intégration tcxarpt2 au format CSV</p><p></p><p>Cordialement.</p><p>GCV6</p><p></p><p><small>Cet e-mail est envoyé automatiquement par la gestion commeciale.</small></p>"


    #print(destinataires)
    #print(emc2_destinataires)
    #return


    # Envoyer l'email avec pièce jointe
    with open(attachment_path, "rb") as attachment:
        response = requests.post(
            mailgun_url,
            auth=("api", mailgun_apikey),
            files={"attachment": (attachment_path, attachment)},
            data={
                "from": mailgun_from,
                "to": destinataires,
                "cc": emc2_destinataires,
                "subject": subject,
                "text": text_content,
                "html": html_content
            },
        )

    # Afficher la réponse de Mailgun
    print(f"Status: {response.status_code}")
    print(f"Response: {response.json()}")

if __name__ == "__main__":
    import sys

    send_email_with_attachment(sys.argv[1])


