__all__ = ["ListeSousTotal", "LongListeSousTotal"]
available_types = __all__


from . import chore
from .Liste import Liste


class ListeSousTotal(Liste):

    def __init__(self, tableau=None, tabularray="tblr", *args, **kwargs):
        Liste.__init__(self, tableau, tabularray, *args, **kwargs)

    def to_latex(self):
        tmpfile = self.texfile.with_suffix(".tmp")
        self.df.to_latex(
            tmpfile,
            columns= self.tableau["colonnes"],
            index=False,
            float_format="%.2f",
        )
        idxfam = 0
        tableau_dict = {idxfam: {"content"  : []} }
        with open(tmpfile) as tmp:
            while line:=tmp.readline():
                if line.strip()=="\\midrule":
                    break

            while line:=tmp.readline():
                if line.strip()=="\\bottomrule":
                    break
                if line.strip().startswith("total"):
                    tableau_dict[idxfam]["total"] = line.strip()
                    idxfam += 1
                    tableau_dict[idxfam] = {"content"  : []}
                else:
                    tableau_dict[idxfam]["content"].append(line.strip())

        # Supprime les lignes vides en fin de tableau
        while tableau_dict[idxfam] == {"content":[]}:
            tableau_dict.pop(idxfam)
            idxfam -=1

        # Différentier la dernière ligne total qui est le total de toutes les lignes
        # Elle marque aussi la fin du tableau est doit ou peut avoir un formatage
        # spécial
        if "total" in tableau_dict[idxfam]:
            cumulTotal = tableau_dict[idxfam]["total"]
            self.variables_to_template["cumulTotal"] = cumulTotal
            tableau_dict.pop(idxfam)
            idxfam -=1

        self.tableau["tableau_dict"] = tableau_dict
        tmpfile.unlink()

        template = chore.liste_jinja_env.get_template("ListeSousTotal.tex.jinja")
        with open(self.texfile, "w") as fp:
            print(template.render(tabularray=self.tabularray, **self.variables_to_template, **self.tableau), file=fp)



class LongListeSousTotal(ListeSousTotal):

    def __init__(self, tableau=None, tabularray="longtblr", *args, **kwargs):
        Liste.__init__(self, tableau, tabularray, *args, **kwargs)

